/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.scheduling.async;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.tslat.aoa3.scheduling.AoAScheduler;

public class CoralStaffTask
implements Runnable {
    private final Level world;
    private final List<BlockPos> coralPositions;
    private static final Block coralBlock = Blocks.BRAIN_CORAL_BLOCK;
    private static final Block deadCoralBlock = Blocks.DEAD_BRAIN_CORAL_BLOCK;

    public CoralStaffTask(Level world, List<BlockPos> coralPositions) {
        this.world = world;
        this.coralPositions = coralPositions;
    }

    @Override
    public void run() {
        for (BlockPos pos : this.coralPositions) {
            Block block = this.world.getBlockState(pos).getBlock();
            if (block != coralBlock && block != deadCoralBlock) continue;
            this.world.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        }
    }

    public void schedule(int time) {
        AoAScheduler.scheduleSyncronisedTask(this, time);
    }
}

