/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.scheduling;

import com.google.common.collect.HashMultimap;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.event.GlobalEvents;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class AoAScheduler {
    private static ScheduledExecutorService scheduler = null;
    private static final HashMultimap<Integer, Runnable> scheduledSynchTasks = HashMultimap.create();
    private static boolean running = true;

    public static void scheduleSyncronisedTask(Runnable run, int ticks) {
        scheduledSynchTasks.put((Object)(GlobalEvents.tick + ticks), (Object)run);
    }

    public static void scheduleAsyncTask(Runnable run, int time, TimeUnit unit) {
        if (scheduler == null || !running) {
            AoAScheduler.serverStartupTasks();
        }
        scheduler.schedule(run, (long)time, unit);
    }

    public static void serverStartupTasks() {
        if (scheduler != null) {
            scheduler.shutdownNow();
        }
        scheduler = Executors.newScheduledThreadPool(1);
        AoAScheduler.handleSyncScheduledTasks(null);
    }

    public static void serverShutdownTasks() {
        AoAScheduler.handleSyncScheduledTasks(null);
        scheduler.shutdownNow();
        scheduler = null;
        running = false;
    }

    public static void handleSyncScheduledTasks(@Nullable Integer tick) {
        if (scheduledSynchTasks.containsKey((Object)tick)) {
            Iterator tasks;
            Iterator iterator = tasks = tick == null ? scheduledSynchTasks.values().iterator() : scheduledSynchTasks.get((Object)tick).iterator();
            while (tasks.hasNext()) {
                try {
                    ((Runnable)tasks.next()).run();
                }
                catch (Exception ex) {
                    Logging.logMessage(Level.ERROR, "Unable to run unhandled scheduled task, skipping.", ex);
                }
                tasks.remove();
            }
        }
    }
}

