/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class InnervationSkill
extends AoASkill.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.afterAttacking(this.serverOnly(this::handleAfterAttacking)), this.onEntityKill(this.serverOnly(this::handleEntityKill)));
    private final Int2ObjectOpenHashMap<Pair<Long, Float>> attackTracker = new Int2ObjectOpenHashMap();

    public InnervationSkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.INNERVATION.get(), plData, jsonData);
    }

    public InnervationSkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.INNERVATION.get(), nbtData);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleAfterAttacking(LivingDamageEvent.Post ev) {
        LivingEntity target = ev.getEntity();
        this.attackTracker.compute(target.getId(), (id, value) -> {
            if (value == null) {
                return Pair.of((Object)target.level().getGameTime(), (Object)Float.valueOf(ev.getNewDamage()));
            }
            return Pair.of((Object)target.level().getGameTime(), (Object)Float.valueOf(Math.min(target.getMaxHealth() * 1.5f, ev.getNewDamage() + ((Float)value.getSecond()).floatValue())));
        });
    }

    private void handleEntityKill(LivingDeathEvent ev) {
        float damageDealt;
        LivingEntity target = ev.getEntity();
        Pair attackEntry = (Pair)this.attackTracker.get(target.getId());
        float f = damageDealt = attackEntry == null ? 5.0f : ((Float)attackEntry.getSecond()).floatValue();
        if (attackEntry != null) {
            this.attackTracker.remove(ev.getEntity().getId());
        }
        if (this.canGainXp(true)) {
            PlayerUtil.giveXpToPlayer((ServerPlayer)this.getPlayer(), this.type(), this.getKillXpForEntity(target, damageDealt), false);
        }
        if (this.attackTracker.size() > 10) {
            this.purgeTracker(target.level().getGameTime());
        }
    }

    private void purgeTracker(long currentTime) {
        this.getAttackEntries().removeIf(entry -> (Long)((Pair)entry.getValue()).getFirst() < currentTime - 1200L);
    }

    public Int2ObjectMap.FastEntrySet<Pair<Long, Float>> getAttackEntries() {
        return this.attackTracker.int2ObjectEntrySet();
    }

    public boolean hasAttackedEntity(Entity entity) {
        return this.attackTracker.containsKey(entity.getId());
    }

    protected float getKillXpForEntity(LivingEntity target, float damageDealt) {
        Mob mob;
        float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), (int)(Math.min(target.getMaxHealth() * 1.5f, damageDealt) / 16.0f * 20.0f));
        double armour = AttributeUtil.getAttributeValue(target, (Holder<Attribute>)Attributes.ARMOR);
        double toughness = armour > 0.0 ? AttributeUtil.getAttributeValue(target, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS) : 0.0;
        double speed = AttributeUtil.getAttributeValue(target, (Holder<Attribute>)Attributes.MOVEMENT_SPEED);
        xp *= 1.0f + (float)(Math.pow(armour / 30.0, 2.0) + Math.pow(toughness / 15.0, 1.5));
        if (target.getPersistentData().contains("spawned_by_spawner")) {
            xp *= 0.25f;
        }
        if (target instanceof FlyingMob || target instanceof Mob && (mob = (Mob)target).getNavigation() instanceof WaterBoundPathNavigation) {
            xp *= 1.1f;
        }
        if (speed > (double)0.3f) {
            xp *= 1.1f;
        }
        if (!EntityUtil.isHostileMob((Entity)target)) {
            xp *= 0.5f;
        }
        if (target.getType().is(Tags.EntityTypes.BOSSES)) {
            xp *= 1.3f;
        }
        return xp;
    }
}

