/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class FaunamancySkill
extends AoASkill.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.afterAttacking(this.serverOnly(this::handleAfterAttacking)));

    public FaunamancySkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.FAUNAMANCY.get(), plData, jsonData);
    }

    public FaunamancySkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.FAUNAMANCY.get(), nbtData);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleAfterAttacking(LivingDamageEvent.Post ev) {
        if (this.canGainXp(true) && FaunamancySkill.isValidSacrifice(ev.getEntity(), this.getPlayer(), ev.getNewDamage())) {
            PlayerUtil.giveTimeBasedXpToPlayer((ServerPlayer)this.getPlayer(), this.type(), (int)(ev.getEntity().getMaxHealth() / 30.0f * 20.0f), false);
        }
    }

    public static boolean isValidSacrifice(LivingEntity target, Player attacker, float damage) {
        if (damage == 0.0f) {
            return false;
        }
        if (target.getHealth() - damage > 0.0f) {
            return false;
        }
        if (!attacker.getMainHandItem().is(AoATags.Items.FAUNAMANCER_TOOL)) {
            return false;
        }
        return target.getDeltaMovement().lengthSqr() < 0.01;
    }
}

