/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.event.custom.events.PlayerSkillsLootModificationEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class ExtractionSkill
extends AoASkill.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerSkillsLootModificationEvent.class, this.serverOnly(this::handleLootModification)), this.listener(PlayerEvent.ItemSmeltedEvent.class, this.serverOnly(this::handleItemSmelted)));

    public ExtractionSkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.EXTRACTION.get(), plData, jsonData);
    }

    public ExtractionSkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.EXTRACTION.get(), nbtData);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleLootModification(PlayerSkillsLootModificationEvent ev) {
        if (!this.canGainXp(true)) {
            return;
        }
        LootContext context = ev.getLootContext();
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state == null) {
            return;
        }
        Vec3 origin = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        if (origin == null) {
            return;
        }
        ServerLevel world = context.getLevel();
        BlockPos pos = BlockPos.containing((Position)origin);
        Block block = state.getBlock();
        if (!Block.isShapeFullBlock((VoxelShape)state.getCollisionShape((BlockGetter)context.getLevel(), pos))) {
            return;
        }
        if (!ExtractionSkill.isApplicableBlock(state)) {
            return;
        }
        float hardness = state.getDestroySpeed((BlockGetter)world, pos);
        float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 2.0f * hardness);
        for (ItemStack item : ev.getGeneratedLoot()) {
            if (item.getItem() == block.asItem()) continue;
            xp *= 2.0f;
            break;
        }
        if (ev.getGeneratedLoot().size() > 2) {
            xp *= 1.5f;
        }
        this.adjustXp(xp, false, false);
    }

    private void handleItemSmelted(PlayerEvent.ItemSmeltedEvent ev) {
        if (ev.getEntity().level().isClientSide() || ev.getSmelting().getCount() <= 0) {
            return;
        }
        ItemStack smelting = ev.getSmelting();
        if (smelting.getFoodProperties((LivingEntity)ev.getEntity()) == null && this.canGainXp(true)) {
            float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 40.0f);
            if (smelting.is(Tags.Items.NUGGETS)) {
                xp *= 1.5f;
            } else if (smelting.is(Tags.Items.INGOTS)) {
                xp *= 2.0f;
            } else if (smelting.is(Tags.Items.GEMS)) {
                xp *= 2.5f;
            }
            this.adjustXp(xp, false, false);
        }
    }

    public static boolean isApplicableBlock(BlockState block) {
        return block.is(AoATags.Blocks.EXTRACTION_TRAINABLE);
    }
}

