/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class DexteritySkill
extends AoASkill.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerTickEvent.Pre.class, PlayerEvent::getEntity, this.serverOnly(this::handlePlayerTick)), this.listener(LivingEvent.LivingJumpEvent.class, LivingEvent::getEntity, this.serverOnly(this::handlePlayerJump)), this.listener(CriticalHitEvent.class, PlayerEvent::getEntity, this.serverOnly(this::handleCriticalHit)));
    private double lastX = 0.0;
    private double lastZ = 0.0;
    private double cumulativeDistance = 0.0;
    private float cumulativeXp = 0.0f;

    public DexteritySkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.DEXTERITY.get(), plData, jsonData);
    }

    public DexteritySkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.DEXTERITY.get(), nbtData);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handlePlayerTick(PlayerTickEvent.Pre ev) {
        if (!this.canGainXp(true) || ev.getEntity().isPassenger()) {
            return;
        }
        Player pl = ev.getEntity();
        Vec3 pos = pl.position();
        if (pl.isSprinting()) {
            if (pl.onGround() || pl.isSwimming()) {
                double distZ;
                double distX;
                double dist;
                if (this.lastX != 0.0 && this.lastZ != 0.0 && (dist = Math.sqrt((distX = pos.x() - this.lastX) * distX + (distZ = pos.z() - this.lastZ) * distZ)) < 1.0) {
                    this.cumulativeDistance += dist;
                }
                this.lastX = pos.x();
                this.lastZ = pos.z();
            }
        } else {
            this.lastX = 0.0;
            this.lastZ = 0.0;
        }
        if (pl.tickCount % 200 == 0) {
            if (this.cumulativeDistance > 0.0) {
                this.cumulativeXp += PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 100.0f) * Math.min(1.65f, (float)(this.cumulativeDistance / 56.0));
                this.cumulativeDistance = 0.0;
            }
            if (this.cumulativeXp > 0.0f) {
                this.adjustXp(this.cumulativeXp, false, false);
                this.cumulativeXp = 0.0f;
            }
        }
    }

    private void handlePlayerJump(LivingEvent.LivingJumpEvent ev) {
        if (!this.canGainXp(true)) {
            return;
        }
        float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 5.0f);
        if (ev.getEntity().isSprinting()) {
            xp *= 1.3f;
        }
        this.cumulativeXp += xp;
    }

    private void handleCriticalHit(CriticalHitEvent ev) {
        if (!this.canGainXp(true)) {
            return;
        }
        this.cumulativeXp += ev.getDamageMultiplier() * PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 12.0f);
    }
}

