/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.tslat.aoa3.advancement.trigger.AoACycleTrigger;
import net.tslat.aoa3.advancement.trigger.AoALevelUpTrigger;
import net.tslat.aoa3.advancement.trigger.AoAXpGainTrigger;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.XpGainPacket;
import net.tslat.aoa3.common.registration.AoAAdvancementTriggers;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public final class AoASkill {
    private final Supplier<MutableComponent> name = Suppliers.memoize(() -> Component.translatable((String)Util.makeDescriptionId((String)"skill", (ResourceLocation)AoARegistries.AOA_SKILLS.getKey(this))));
    private final BiFunction<ServerPlayerDataManager, JsonObject, Instance> jsonFactory;
    private final Function<CompoundTag, Instance> clientFactory;

    public AoASkill(BiFunction<ServerPlayerDataManager, JsonObject, Instance> jsonFactory, Function<CompoundTag, Instance> clientFactory) {
        this.jsonFactory = jsonFactory;
        this.clientFactory = clientFactory;
    }

    public MutableComponent getName() {
        return this.name.get();
    }

    public Instance buildDefaultInstance(ServerPlayerDataManager plData, JsonObject resourceData) {
        return this.jsonFactory.apply(plData, resourceData);
    }

    public Instance buildClientInstance(CompoundTag resourceData) {
        return this.clientFactory.apply(resourceData);
    }

    public static abstract class Instance
    implements AoAPlayerEventListener {
        private final AoASkill skill;
        private final HashMap<String, AoAAbility.Instance> abilities = new HashMap();
        protected ServerPlayerDataManager playerDataManager;
        protected int cycle = 0;
        protected int level = 1;
        protected float xp = 0.0f;
        protected float xpModifier = 1.0f;
        public boolean needsSync = true;

        protected Instance(AoASkill skill, ServerPlayerDataManager plData, JsonObject instanceData) {
            this.skill = skill;
            if (instanceData != null) {
                this.playerDataManager = plData;
                this.xpModifier = GsonHelper.getAsFloat((JsonObject)instanceData, (String)"xp_modifier", (float)1.0f);
                if (instanceData.has("abilities")) {
                    for (JsonElement entry : instanceData.getAsJsonArray("abilities")) {
                        JsonObject abilityData = entry.getAsJsonObject();
                        AoAAbility ability = AoAAbilities.getAbility((ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)abilityData, (String)"id")).getOrThrow());
                        AoAAbility.Instance instance = ability.create(this, abilityData);
                        this.abilities.put(instance.getUniqueIdentifier(), instance);
                    }
                }
            }
        }

        protected Instance(AoASkill skill, CompoundTag instanceData) {
            this.skill = skill;
            float f = this.xpModifier = instanceData.contains("xp_modifier") ? instanceData.getFloat("xp_modifier") : 1.0f;
            if (instanceData.contains("abilities")) {
                CompoundTag abilityData = instanceData.getCompound("abilities");
                for (String key : abilityData.getAllKeys()) {
                    AoAAbility ability = AoAAbilities.getAbility((ResourceLocation)ResourceLocation.read((String)abilityData.getCompound(key).getString("id")).getOrThrow());
                    AoAAbility.Instance instance = ability.loadFromNbt(this, (CompoundTag)abilityData.get(key));
                    this.abilities.put(instance.getUniqueIdentifier(), instance);
                }
            }
        }

        @Override
        public List<DynamicEventSubscriber<? extends Event>> getEventSubscribers() {
            return Collections.emptyList();
        }

        public void changePlayerInstance(ServerPlayerDataManager plData) {
            this.playerDataManager = plData;
        }

        public AoASkill type() {
            return this.skill;
        }

        public MutableComponent getName() {
            return this.type().getName().copy();
        }

        @Override
        public boolean isStillValid() {
            return this.playerDataManager != null && this.playerDataManager.isStillValid();
        }

        public HashMap<String, AoAAbility.Instance> getAbilityMap() {
            return this.abilities;
        }

        @Override
        public Player getPlayer() {
            return this.playerDataManager == null ? ClientOperations.getPlayer() : this.playerDataManager.getPlayer();
        }

        public ServerPlayerDataManager getPlayerDataManager() {
            return this.playerDataManager;
        }

        public float getXp() {
            return this.xp;
        }

        public int getLevel(boolean includeVanityLevels) {
            return includeVanityLevels ? this.level : Math.min(this.level, 100);
        }

        public int getCycles() {
            return this.cycle;
        }

        public boolean hasLevel(int levelReq) {
            return this.getLevel(true) >= levelReq;
        }

        public void setLevel(int newLevel) {
            int oldLevel = this.level;
            this.level = Mth.clamp((int)newLevel, (int)0, (int)1000);
            this.xp = 0.0f;
            this.needsSync = true;
            this.playerDataManager.applyLegitimacyPenalties();
            AoAEvents.firePlayerLevelChange(this.playerDataManager, this, oldLevel, false);
        }

        public void applyXpModifier(float xpMod) {
            this.xpModifier += xpMod;
            this.needsSync = true;
        }

        public void removeXpModifier(float xpMod) {
            this.xpModifier -= xpMod;
            this.needsSync = true;
        }

        private float applyXpBuffs(float xp) {
            xp = (float)((double)xp * (Double)AoAConfigs.SERVER.globalXpModifier.get());
            if (WorldUtil.isWorld(this.getPlayer().level(), AoADimensions.NOWHERE)) {
                xp *= 0.5f;
            }
            xp *= this.xpModifier;
            if (this.cycle > 0) {
                xp *= (float)(3 * this.cycle);
            }
            return Math.max(0.0f, xp);
        }

        public void adjustXp(float xp, boolean isUnnaturalSource, boolean ignoreXpBuffs) {
            float xpAfterMods = xp;
            if (!isUnnaturalSource && !ignoreXpBuffs) {
                xpAfterMods = this.applyXpBuffs(xp);
            }
            if ((xp = AoAEvents.firePlayerChangeXp(this.playerDataManager, this, xp, xpAfterMods, !isUnnaturalSource)) > 0.0f) {
                if (this.level >= 1000) {
                    return;
                }
            } else {
                if (xp == 0.0f) {
                    return;
                }
                if (this.level == 1) {
                    return;
                }
                this.subtractXp(xp, isUnnaturalSource);
                return;
            }
            float remaining = Math.min(5.4413235E8f, xp);
            int newLevels = 0;
            float xpRemaining = PlayerUtil.getXpRemainingUntilLevel(this.playerDataManager, this.skill);
            if (remaining > xpRemaining) {
                remaining -= xpRemaining;
                ++newLevels;
                while (true) {
                    float f;
                    float stillRemaining = remaining - PlayerUtil.getXpRequiredForNextLevel(this.level + newLevels);
                    if (!(f >= 0.0f) || this.level + newLevels >= 1000) break;
                    remaining = stillRemaining;
                    ++newLevels;
                }
            }
            if (newLevels > 0) {
                this.levelUp(this.level, this.level + newLevels, !isUnnaturalSource);
            }
            if (isUnnaturalSource) {
                this.playerDataManager.applyLegitimacyPenalties();
            } else {
                ((AoAXpGainTrigger)((Object)AoAAdvancementTriggers.XP_GAIN.get())).trigger(this.playerDataManager.getPlayer(), this.skill, xp);
            }
            this.xp += remaining;
            this.needsSync = true;
            this.playerDataManager.checkAndUpdateLegitimacy();
            AoANetworking.sendToPlayer(this.playerDataManager.getPlayer(), new XpGainPacket(AoARegistries.AOA_SKILLS.getKey(this.skill), xp, newLevels > 0));
        }

        private void subtractXp(float xp, boolean isUnnaturalSource) {
            float remaining = Math.min(5.4413235E8f, Math.abs(xp));
            int newLevels = 0;
            if (this.level >= 1 && remaining >= this.xp) {
                remaining -= this.xp;
                ++newLevels;
                while (true) {
                    float f;
                    float stillRemaining = remaining - PlayerUtil.getXpRequiredForNextLevel(this.level - newLevels - 1);
                    if (!(f >= 0.0f) || this.level - newLevels <= 1) break;
                    remaining = stillRemaining;
                    ++newLevels;
                }
            }
            if (newLevels > 0) {
                this.level = Math.max(1, this.level - newLevels);
                AoAEvents.firePlayerLevelChange(this.playerDataManager, this, this.level + newLevels, !isUnnaturalSource);
            }
            this.xp = Math.max(0.0f, PlayerUtil.getXpRequiredForNextLevel(this.level - newLevels) - remaining);
            this.needsSync = true;
            if (!isUnnaturalSource) {
                this.playerDataManager.applyLegitimacyPenalties();
            }
            AoANetworking.sendToPlayer(this.playerDataManager.getPlayer(), new XpGainPacket(AoARegistries.AOA_SKILLS.getKey(this.skill), xp, newLevels > 0));
        }

        private void levelUp(int oldLevel, int newLevel, boolean isNaturalLevel) {
            ServerPlayer player = this.playerDataManager.getPlayer();
            new SoundBuilder((Holder<SoundEvent>)AoASounds.PLAYER_LEVEL_UP).isPlayer().notInWorld().include(new Player[]{player}).execute();
            if ((newLevel == 100 || newLevel == 1000) && oldLevel < newLevel) {
                AoAScheduler.scheduleSyncronisedTask(() -> new SoundBuilder((Holder<SoundEvent>)(newLevel == 100 ? AoASounds.PLAYER_LEVEL_UP_100 : AoASounds.PLAYER_LEVEL_UP_1000)).isPlayer().notInWorld().include(new Player[]{player}).execute(), 40);
            }
            this.level = newLevel;
            this.xp = 0.0f;
            AoAEvents.firePlayerLevelChange(this.playerDataManager, this, oldLevel, isNaturalLevel);
            ((AoALevelUpTrigger)((Object)AoAAdvancementTriggers.LEVEL_UP.get())).trigger(player, this.skill, newLevel);
        }

        public boolean addCycle() {
            if (this.level >= 100 && this.cycle < 10) {
                int oldLevel = this.level;
                ++this.cycle;
                this.level = 1;
                this.xp = 0.0f;
                this.needsSync = true;
                AoAEvents.firePlayerLevelChange(this.playerDataManager, this, oldLevel, true);
                ((AoACycleTrigger)((Object)AoAAdvancementTriggers.CYCLE_SKILL.get())).trigger(this.playerDataManager.getPlayer(), this.skill, this.cycle);
                return true;
            }
            return false;
        }

        public void setCycle(int cycle) {
            this.cycle = Mth.clamp((int)cycle, (int)0, (int)10);
            this.needsSync = true;
            this.playerDataManager.applyLegitimacyPenalties();
        }

        public CompoundTag saveToNbt() {
            CompoundTag skillData = new CompoundTag();
            CompoundTag abilityData = new CompoundTag();
            skillData.putInt("cycle", this.cycle);
            skillData.putInt("level", this.level);
            skillData.putFloat("xp", this.xp);
            for (Map.Entry<String, AoAAbility.Instance> ability : this.getAbilityMap().entrySet()) {
                CompoundTag abilityNbt = ability.getValue().saveToNbt();
                if (abilityNbt == null) continue;
                abilityData.put(ability.getKey(), (Tag)abilityNbt);
            }
            skillData.put("abilities", (Tag)abilityData);
            return skillData;
        }

        public void loadFromNbt(CompoundTag skillData) {
            this.level = 1;
            this.xp = 0.0f;
            if (skillData.contains("cycle")) {
                this.cycle = skillData.getInt("cycle");
            }
            if (skillData.contains("level")) {
                this.level = skillData.getInt("level");
            }
            if (skillData.contains("xp")) {
                this.xp = skillData.getFloat("xp");
            }
            if (skillData.contains("abilities")) {
                CompoundTag abilityData = skillData.getCompound("abilities");
                for (AoAAbility.Instance ability : this.getAbilityMap().values()) {
                    if (abilityData.contains(ability.getUniqueIdentifier())) {
                        ability.loadFromNbt(abilityData.getCompound(ability.getUniqueIdentifier()));
                        continue;
                    }
                    ability.checkDeactivation(false, false);
                }
            }
        }

        public CompoundTag getSyncData(boolean forClientSetup) {
            CompoundTag data = new CompoundTag();
            CompoundTag abilityData = new CompoundTag();
            data.putInt("cycle", this.cycle);
            data.putInt("level", this.level);
            data.putFloat("xp", this.xp);
            data.putFloat("xpMod", this.xpModifier);
            for (Map.Entry<String, AoAAbility.Instance> ability : this.getAbilityMap().entrySet()) {
                AoAAbility.Instance instance = ability.getValue();
                if (!instance.needsSync && !forClientSetup) continue;
                abilityData.put(instance.getUniqueIdentifier(), (Tag)instance.getSyncData(forClientSetup));
                instance.needsSync = false;
            }
            if (!abilityData.isEmpty()) {
                data.put("abilities", (Tag)abilityData);
            }
            if (!forClientSetup) {
                this.needsSync = false;
            }
            return data;
        }

        public void receiveSyncData(CompoundTag data) {
            this.cycle = data.getInt("cycle");
            this.level = data.getInt("level");
            this.xp = data.getFloat("xp");
            this.xpModifier = data.getFloat("xpMod");
            if (data.contains("abilities")) {
                CompoundTag abilityData = data.getCompound("abilities");
                for (String key : abilityData.getAllKeys()) {
                    AoAAbility.Instance ability = this.abilities.get(key);
                    if (ability == null) continue;
                    ability.receiveSyncData(abilityData.getCompound(key));
                }
            }
        }

        public boolean canGainXp(boolean naturalXpSource) {
            Player player = this.getPlayer();
            if (naturalXpSource && (player.isCreative() || player.isSpectator())) {
                return false;
            }
            return this.getLevel(true) < 1000;
        }
    }
}

