/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.resource;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;
import org.jetbrains.annotations.NotNull;

public class SpiritResource
extends AoAResource.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.afterAttacking(this::handleAfterAttacking), this.listener(PlayerTickEvent.Pre.class, PlayerEvent::getEntity, this::handlePlayerTick));
    private final float maxValue;
    private final float regenPerTick;
    private final float regenPerDamage;
    private final float healthModMax;
    private float value = 0.0f;

    public SpiritResource(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoAResource)AoAResources.SPIRIT.get(), plData);
        this.maxValue = Math.max(0.0f, GsonHelper.getAsFloat((JsonObject)jsonData, (String)"max_value"));
        this.regenPerTick = GsonHelper.getAsFloat((JsonObject)jsonData, (String)"regen_per_tick", (float)0.04f);
        this.regenPerDamage = GsonHelper.getAsFloat((JsonObject)jsonData, (String)"regen_per_damage", (float)0.4f);
        this.healthModMax = GsonHelper.getAsFloat((JsonObject)jsonData, (String)"inverse_health_regen_mod", (float)3.5f);
    }

    public SpiritResource(CompoundTag nbtData) {
        super((AoAResource)AoAResources.SPIRIT.get(), null);
        this.maxValue = nbtData.getFloat("max_value");
        this.regenPerTick = nbtData.getFloat("regen_per_tick");
        this.regenPerDamage = nbtData.getFloat("regen_per_damage");
        this.healthModMax = nbtData.getFloat("inverse_health_regen_mod");
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public float getCurrentValue() {
        return this.value;
    }

    @Override
    public void setValue(float amount) {
        this.value = Mth.clamp((float)amount, (float)0.0f, (float)this.getMaxValue());
    }

    @Override
    public float getMaxValue() {
        return this.maxValue;
    }

    @Override
    public float getPerTickRegen() {
        return this.regenPerTick;
    }

    private void handleAfterAttacking(LivingDamageEvent.Post ev) {
        if (this.value < this.getMaxValue() && !ev.getSource().is(AoATags.DamageTypes.NO_SPIRIT_REGEN)) {
            this.addValue(this.getHealthScaledRegen(this.regenPerDamage * ev.getNewDamage()));
        }
    }

    private void handlePlayerTick(PlayerTickEvent.Pre ev) {
        if (this.value < this.getMaxValue()) {
            this.addValue(this.getHealthScaledRegen(this.getPerTickRegen()));
        }
    }

    protected float getHealthScaledRegen(float regenAmount) {
        ServerPlayer player = this.getPlayerDataManager().getPlayer();
        return (1.0f + (1.0f - player.getHealth() / player.getMaxHealth()) * (this.healthModMax - 1.0f)) * regenAmount;
    }

    @Override
    @NotNull
    public CompoundTag saveToNbt() {
        return new CompoundTag();
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = new CompoundTag();
        if (forClientSetup) {
            data.putFloat("max_value", this.getMaxValue());
            data.putFloat("inverse_health_regen_mod", this.healthModMax);
            data.putFloat("regen_per_damage", this.regenPerDamage);
            data.putFloat("regen_per_tick", this.getPerTickRegen());
        } else {
            data.putFloat("value", this.getCurrentValue());
        }
        return data;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        if (data.contains("value")) {
            this.value = data.getFloat("value");
        }
    }
}

