/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.innervation;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.NumberUtil;

public class VulcaneDamageIncrease
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.whenAttacking(this.serverOnly(this::handleOutgoingAttack)));
    private final float minRage;
    private final float modifier;

    public VulcaneDamageIncrease(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.VULCANE_DAMAGE_INCREASE.get(), skill, data);
        this.minRage = GsonHelper.getAsFloat((JsonObject)data, (String)"min_rage", (float)0.0f);
        this.modifier = GsonHelper.getAsFloat((JsonObject)data, (String)"modifier");
    }

    public VulcaneDamageIncrease(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.VULCANE_DAMAGE_INCREASE.get(), skill, data);
        this.minRage = data.getFloat("min_rage");
        this.modifier = data.getFloat("modifier");
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + (this.minRage > 0.0f ? ".minRage" : "")), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace((this.modifier - 1.0f) * 100.0f, 2), NumberUtil.roundToNthDecimalPlace(this.minRage, 2)}));
    }

    private void handleOutgoingAttack(LivingIncomingDamageEvent ev) {
        if (DamageUtil.isVulcaneDamage(ev.getSource())) {
            ev.setAmount(ev.getAmount() * this.modifier);
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putFloat("min_rage", this.minRage);
            data.putFloat("modifier", this.modifier);
        }
        return data;
    }
}

