/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.innervation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.aoa3.util.StringUtil;

public class PotionDurationReducer
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(MobEffectEvent.Added.class, LivingEvent::getEntity, this.serverOnly(this::handleAppliedMobEffect)));
    private final float modifier;
    private final boolean useAddition;
    private final MobEffectCategory matchType;
    private final HashSet<ResourceLocation> matchEffects;
    private final Consumer<MobEffectInstance> modifierConsumer;

    public PotionDurationReducer(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.POTION_DURATION_REDUCER.get(), skill, data);
        this.modifier = GsonHelper.getAsFloat((JsonObject)data, (String)"modifier");
        this.useAddition = GsonHelper.getAsBoolean((JsonObject)data, (String)"use_addition", (boolean)false);
        if (data.has("match_effect_type")) {
            this.matchType = MobEffectCategory.valueOf((String)data.get("match_effect_type").getAsString());
            this.matchEffects = null;
        } else {
            this.matchEffects = new HashSet();
            JsonElement effects = data.get("match_effects");
            if (effects.isJsonPrimitive()) {
                this.matchEffects.add((ResourceLocation)ResourceLocation.read((String)effects.getAsString()).getOrThrow());
            } else if (effects.isJsonArray()) {
                for (JsonElement element : effects.getAsJsonArray()) {
                    this.matchEffects.add((ResourceLocation)ResourceLocation.read((String)element.getAsString()).getOrThrow());
                }
            }
            this.matchType = null;
        }
        this.modifierConsumer = effect -> {
            effect.duration = this.useAddition ? (effect.duration += (int)this.modifier) : (int)((float)effect.duration * this.modifier);
        };
    }

    public PotionDurationReducer(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.POTION_DURATION_REDUCER.get(), skill, data);
        this.modifier = data.getFloat("modifier");
        this.useAddition = data.getBoolean("use_addition");
        if (data.contains("match_effect_type")) {
            this.matchType = MobEffectCategory.valueOf((String)data.getString("match_effect_type"));
            this.matchEffects = null;
        } else {
            this.matchEffects = new HashSet();
            Tag effects = data.get("match_effects");
            if (effects.getType() == StringTag.TYPE) {
                this.matchEffects.add((ResourceLocation)ResourceLocation.read((String)effects.getAsString()).getOrThrow());
            } else if (effects.getType() == ListTag.TYPE) {
                for (Tag element : (ListTag)effects) {
                    this.matchEffects.add((ResourceLocation)ResourceLocation.read((String)element.getAsString()).getOrThrow());
                }
            }
            this.matchType = null;
        }
        this.modifierConsumer = null;
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        String value;
        String operationSuffix = this.useAddition ? ".addition" : ".multiply";
        String string = value = this.useAddition ? NumberUtil.roundToNthDecimalPlace(this.modifier, 2) : NumberUtil.roundToNthDecimalPlace((this.modifier - 1.0f) * 100.0f, 2);
        if (this.matchType != null) {
            super.updateDescription(Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + operationSuffix + ".type"), (Object[])new Object[]{StringUtil.toTitleCase(this.matchType.toString()), value}));
        } else {
            super.updateDescription(Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + operationSuffix + ".list"), (Object[])new Object[]{value}));
        }
    }

    private void handleAppliedMobEffect(MobEffectEvent.Added ev) {
        MobEffectInstance effect = ev.getEffectInstance();
        if (!this.effectMatches(effect)) {
            return;
        }
        this.reduceEffectDuration(effect, this.modifierConsumer);
    }

    private boolean effectMatches(MobEffectInstance effect) {
        if (this.matchType != null) {
            return ((MobEffect)effect.getEffect().value()).getCategory() == this.matchType;
        }
        return this.matchEffects.contains(effect.getEffect().unwrapKey().map(ResourceKey::location).orElseGet(() -> RegistryUtil.getId((MobEffect)effect.getEffect().value())));
    }

    private void reduceEffectDuration(MobEffectInstance effect, Consumer<MobEffectInstance> modifier) {
        modifier.accept(effect);
        if (effect.hiddenEffect != null) {
            this.reduceEffectDuration(effect.hiddenEffect, this.modifierConsumer);
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putFloat("modifier", this.modifier);
            data.putBoolean("use_addition", this.useAddition);
            if (this.matchType != null) {
                data.putString("match_effect_type", this.matchType.toString());
            } else {
                ListTag effects = new ListTag();
                for (ResourceLocation id : this.matchEffects) {
                    effects.add((Object)StringTag.valueOf((String)id.toString()));
                }
                data.put("match_effects", (Tag)effects);
            }
        }
        return data;
    }
}

