/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.innervation;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class OneShotDamageLimiter
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(LivingDamageEvent.Pre.class, LivingEvent::getEntity, this.serverOnly(this::handlePreDamageApplication)));
    private final float restoreHealthTo;
    private final float minActivationHealth;

    public OneShotDamageLimiter(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.ONE_SHOT_DAMAGE_LIMITER.get(), skill, data);
        this.restoreHealthTo = GsonHelper.getAsFloat((JsonObject)data, (String)"health_restore_amount", (float)1.0f);
        this.minActivationHealth = GsonHelper.getAsFloat((JsonObject)data, (String)"min_activation_health", (float)0.0f);
    }

    public OneShotDamageLimiter(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.ONE_SHOT_DAMAGE_LIMITER.get(), skill, data);
        this.restoreHealthTo = data.getFloat("health_restore_amount");
        this.minActivationHealth = data.getFloat("min_activation_health");
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        if (this.minActivationHealth <= 0.0f) {
            super.updateDescription(Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + ".full"), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.restoreHealthTo, 2)}));
        } else {
            super.updateDescription(Component.translatable((String)((TranslatableContents)defaultDescription.getContents()).getKey(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.minActivationHealth, 2), NumberUtil.roundToNthDecimalPlace(this.restoreHealthTo, 2)}));
        }
    }

    private void handlePreDamageApplication(LivingDamageEvent.Pre ev) {
        if (ev.getContainer().getSource().is(Tags.DamageTypes.IS_TECHNICAL)) {
            return;
        }
        LivingEntity player = ev.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            if (player.getHealth() - ev.getContainer().getNewDamage() <= 0.0f) {
                float f = player.getHealth();
                float f2 = this.minActivationHealth == 0.0f ? player.getMaxHealth() : this.minActivationHealth;
                if (f >= f2) {
                    ev.getContainer().setNewDamage(0.0f);
                    player.setHealth(this.restoreHealthTo);
                    this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.ENERGY.get()).setValue(0.0f);
                    if (this.skill.canGainXp(true)) {
                        PlayerUtil.giveTimeBasedXpToPlayer(pl, this.skill.type(), 500, false);
                    }
                }
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putFloat("health_restore_amount", this.restoreHealthTo);
            data.putFloat("min_activation_health", this.minActivationHealth);
        }
        return data;
    }
}

