/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.innervation;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;

public class OnKillDamageBoost
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.whenAttacking(this.serverOnly(this::handleOutgoingAttack)), this.onEntityKill(this.serverOnly(this::handleEntityKill)));
    private long boostExpiry;
    private final float modifier;
    private final int postKillDuration;

    public OnKillDamageBoost(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.ON_KILL_DAMAGE_BOOST.get(), skill, data);
        this.modifier = GsonHelper.getAsFloat((JsonObject)data, (String)"modifier");
        this.postKillDuration = GsonHelper.getAsInt((JsonObject)data, (String)"post_kill_ticks");
    }

    public OnKillDamageBoost(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.ON_KILL_DAMAGE_BOOST.get(), skill, data);
        this.modifier = data.getFloat("modifier");
        this.postKillDuration = data.getInt("post_kill_ticks");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.translatable((String)((TranslatableContents)defaultDescription.getContents()).getKey(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace((this.modifier - 1.0f) * 100.0f, 2), NumberUtil.roundToNthDecimalPlace((float)this.postKillDuration / 20.0f, 2)}));
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleOutgoingAttack(LivingIncomingDamageEvent ev) {
        if (ev.getEntity().level().getGameTime() < this.boostExpiry && !ev.getSource().is(DamageTypeTags.IS_EXPLOSION)) {
            ev.setAmount(ev.getAmount() * this.modifier);
        }
    }

    private void handleEntityKill(LivingDeathEvent ev) {
        this.boostExpiry = ev.getEntity().level().getGameTime() + (long)this.postKillDuration;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putFloat("modifier", this.modifier);
            data.putInt("post_kill_ticks", this.postKillDuration);
        }
        return data;
    }
}

