/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.innervation;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.player.AoAPlayerKeybindListener;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.library.constant.ScreenImageEffect;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class InnervationMobLure
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerTickEvent.Pre.class, PlayerEvent::getEntity, this.serverOnly(this::handlePlayerTick)), this.whenTakingDamage(this.serverOnly(this::handleIncomingDamage)));
    private final float onHitDrain;
    private final float perTickDrain;
    private final float luredDamageModifier;
    private boolean isLuring = false;
    private Mob luringEntity = null;

    public InnervationMobLure(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.INNERVATION_MOB_LURE.get(), skill, data);
        this.onHitDrain = GsonHelper.getAsFloat((JsonObject)data, (String)"on_hit_drain");
        this.perTickDrain = GsonHelper.getAsFloat((JsonObject)data, (String)"per_tick_spirit_drain");
        this.luredDamageModifier = GsonHelper.getAsFloat((JsonObject)data, (String)"lured_damage_modifier", (float)0.5f);
    }

    public InnervationMobLure(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.INNERVATION_MOB_LURE.get(), skill, data);
        this.onHitDrain = data.getFloat("on_hit_drain");
        this.perTickDrain = data.getFloat("per_tick_spirit_drain");
        this.luredDamageModifier = data.getFloat("lured_damage_modifier");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.translatable((String)((TranslatableContents)defaultDescription.getContents()).getKey(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.perTickDrain * 20.0f, 2), NumberUtil.roundToNthDecimalPlace(this.luredDamageModifier * 100.0f, 2), NumberUtil.roundToNthDecimalPlace(this.onHitDrain, 2)}));
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public void createKeybindListener(Consumer<AoAPlayerKeybindListener> consumer) {
        consumer.accept(new AoAPlayerKeybindListener(){

            @Override
            public AoAPlayerEventListener getEventListener() {
                return InnervationMobLure.this;
            }

            @Override
            public int getKeycode() {
                return AoAKeybinds.ABILITY_ACTION.getKey().getValue();
            }

            @Override
            public boolean shouldSendKeyPress() {
                return InnervationMobLure.this.getPlayer().isCrouching();
            }
        });
    }

    @Override
    public void handleKeyInput() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            LivingEntity livingEntity;
            ServerPlayer player2 = (ServerPlayer)player;
            if (!this.isLuring && player2.isCrouching() && (livingEntity = player2.getLastHurtMob()) instanceof Mob) {
                Mob mob;
                this.luringEntity = mob = (Mob)livingEntity;
                this.isLuring = true;
                this.activatedActionKey(player2);
            }
        }
    }

    private void handlePlayerTick(PlayerTickEvent.Pre ev) {
        if (!this.isLuring) {
            return;
        }
        Player pl = ev.getEntity();
        if (this.luringEntity == null || this.luringEntity.isDeadOrDying() || pl.isDeadOrDying() || !pl.isCrouching() || !this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.SPIRIT.get()).consume(this.perTickDrain, true)) {
            this.resetLureState();
            return;
        }
        if (pl.level().getGameTime() % 10L == 0L && pl instanceof ServerPlayer) {
            ServerPlayer serverPl = (ServerPlayer)pl;
            new ScreenImageEffect(ScreenImageEffect.Type.ACTION_KEY_VIGNETTE).fullscreen(true).duration(10).sendToPlayer(serverPl);
        }
        if (this.luringEntity.getTarget() != pl) {
            this.luringEntity.setTarget((LivingEntity)pl);
        }
    }

    private void handleIncomingDamage(LivingIncomingDamageEvent ev) {
        if (this.isLuring && ev.getSource().getEntity() == this.luringEntity) {
            this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.SPIRIT.get()).consume(this.onHitDrain, true);
            ev.setAmount(ev.getAmount() * this.luredDamageModifier);
            this.resetLureState();
            if (this.skill.canGainXp(true)) {
                PlayerUtil.giveTimeBasedXpToPlayer((ServerPlayer)this.getPlayer(), this.skill.type(), 30, false);
            }
        }
    }

    private void resetLureState() {
        this.isLuring = false;
        this.luringEntity = null;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putFloat("on_hit_drain", this.onHitDrain);
            data.putFloat("per_tick_spirit_drain", this.perTickDrain);
            data.putFloat("lured_damage_modifier", this.luredDamageModifier);
        }
        return data;
    }
}

