/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.innervation;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;

public class BowDamageIncrease
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.whenAttacking(this.serverOnly(this::handleOutgoingAttack)));
    private final boolean requireFullyCharged;
    private final float modifier;

    public BowDamageIncrease(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.BOW_DAMAGE_INCREASE.get(), skill, data);
        this.requireFullyCharged = GsonHelper.getAsBoolean((JsonObject)data, (String)"require_full_charge", (boolean)true);
        this.modifier = GsonHelper.getAsFloat((JsonObject)data, (String)"modifier");
    }

    public BowDamageIncrease(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.BOW_DAMAGE_INCREASE.get(), skill, data);
        this.requireFullyCharged = data.getBoolean("require_full_charge");
        this.modifier = data.getFloat("modifier");
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + (this.requireFullyCharged ? ".fullCharge" : "")), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace((this.modifier - 1.0f) * 100.0f, 2)}));
    }

    private void handleOutgoingAttack(LivingIncomingDamageEvent ev) {
        Entity entity;
        DamageSource source = ev.getSource();
        if (source.is(DamageTypeTags.IS_PROJECTILE) && (entity = source.getDirectEntity()) instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            if (!this.requireFullyCharged || arrow.isCritArrow()) {
                ev.setAmount(ev.getAmount() * this.modifier);
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putBoolean("require_full_charge", this.requireFullyCharged);
            data.putFloat("modifier", this.modifier);
        }
        return data;
    }
}

