/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.imbuing;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.content.item.misc.PowerStone;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;

public class EnchantContainerContents
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerInteractEvent.RightClickBlock.class, PlayerEvent::getEntity, this.serverOnly(this::handleBlockInteraction)));

    public EnchantContainerContents(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.ENCHANT_CONTAINER_CONTENTS.get(), skill, data);
    }

    public EnchantContainerContents(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.ENCHANT_CONTAINER_CONTENTS.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleBlockInteraction(PlayerInteractEvent.RightClickBlock ev) {
        Item item = ev.getItemStack().getItem();
        if (item instanceof PowerStone) {
            BlockPos pos;
            PowerStone powerStone = (PowerStone)item;
            ServerPlayer player = (ServerPlayer)ev.getEntity();
            if (!player.isCrouching()) {
                return;
            }
            ServerLevel level = player.serverLevel();
            BlockEntity blockEntity = level.getBlockEntity(pos = ev.getPos());
            if (blockEntity instanceof Container) {
                ChestBlock chestBlock;
                Block block;
                Container container = (Container)blockEntity;
                BlockState blockState = level.getBlockState(pos);
                if (container instanceof ChestBlockEntity && (block = blockState.getBlock()) instanceof ChestBlock && (container = ChestBlock.getContainer((ChestBlock)(chestBlock = (ChestBlock)block), (BlockState)blockState, (Level)level, (BlockPos)pos, (boolean)true)) == null) {
                    return;
                }
                int enchantLevel = powerStone.getEnchantLevel();
                int enchantedCount = 0;
                for (int i = 0; i < container.getContainerSize(); ++i) {
                    ItemStack stack = container.getItem(i);
                    if (!stack.isEnchantable() || stack.getItem() == Items.BOOK) continue;
                    EnchantmentHelper.enchantItem((RandomSource)player.getRandom(), (ItemStack)stack, (int)enchantLevel, (RegistryAccess)level.registryAccess(), Optional.empty());
                    ++enchantedCount;
                }
                if (enchantedCount > 0) {
                    PlayerUtil.giveTimeBasedXpToPlayer(player, this.skill.type(), 100 * enchantedCount * enchantLevel, false);
                    if (!player.getAbilities().instabuild) {
                        ev.getItemStack().shrink(1);
                    }
                    level.playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TELParticlePacket packet = new TELParticlePacket();
                    for (int i = 0; i < 100; ++i) {
                        packet.particle(ParticleBuilder.forRandomPosInBlock((ParticleOptions)ParticleTypes.GLOW, (BlockPos)pos).colourOverride(player.getRandom().nextIntBetweenInclusive(100, 220), 0, 255, 255));
                    }
                    if (blockState.getBlock() instanceof ChestBlock && blockState.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
                        BlockPos attachedPos = pos.relative(ChestBlock.getConnectedDirection((BlockState)blockState));
                        for (int i = 0; i < 100; ++i) {
                            packet.particle(ParticleBuilder.forRandomPosInBlock((ParticleOptions)ParticleTypes.GLOW, (BlockPos)attachedPos).colourOverride(player.getRandom().nextIntBetweenInclusive(100, 220), 0, 255, 255));
                        }
                    }
                    packet.sendToAllPlayersTrackingBlock(level, pos);
                    ev.setCanceled(true);
                }
            }
        }
    }
}

