/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.hauling;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.smartbrainlib.util.RandomUtil;

public class FishingXpBoost
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(ItemFishedEvent.class, this.serverOnly(this::handleItemFished)));
    private final boolean useAddition;

    public FishingXpBoost(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.FISHING_XP_BOOST.get(), skill, data);
        this.useAddition = GsonHelper.getAsBoolean((JsonObject)data, (String)"use_addition", (boolean)false);
    }

    public FishingXpBoost(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.FISHING_XP_BOOST.get(), skill, data);
        this.useAddition = data.getBoolean("use_addition");
    }

    @Override
    protected boolean isPercent() {
        return !this.useAddition;
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleItemFished(ItemFishedEvent ev) {
        if (ev instanceof HaulingItemFishedEvent) {
            HaulingItemFishedEvent haulingEv = (HaulingItemFishedEvent)ev;
            float xp = haulingEv.getXp();
            xp = this.useAddition ? (xp += this.getScaledValue()) : (xp *= 1.0f + this.getScaledValue());
            haulingEv.setXp((int)xp);
        } else {
            Player player = ev.getEntity();
            player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), player.getX() + 0.5, player.getY() + 0.5, player.getZ() + 0.5, RandomUtil.randomNumberBetween((int)1, (int)6)));
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putBoolean("use_addition", this.useAddition);
        }
        return data;
    }
}

