/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.hauling;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.skill.hauling.HaulingSpawnPool;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.event.custom.events.PlayerChangeXpEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public class FishingTrapSpawn
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(ItemFishedEvent.class, this.serverOnly(this::handleItemFished)), this.listener(PlayerChangeXpEvent.class, this.serverOnly(this::handleSkillXpGain)));

    public FishingTrapSpawn(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.FISHING_TRAP_SPAWN.get(), skill, data);
    }

    public FishingTrapSpawn(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.FISHING_TRAP_SPAWN.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    protected MutableComponent getScalingDescriptionComponent(int precision) {
        return LocaleUtil.getAbilityValueDesc(this.baseValue != 0.0f, this.perLevelMod != 0.0f, this.isPercent(), NumberUtil.roundToNthDecimalPlace(this.baseValue * (float)(this.isPercent() ? 100 : 1), precision), NumberUtil.roundToNthDecimalPlace(this.perLevelMod * (float)(this.isPercent() ? 100 : 1), precision), NumberUtil.roundToNthDecimalPlace(Math.max(0.0f, this.getScaledValue() * (float)(this.isPercent() ? 100 : 1)), precision));
    }

    private void handleItemFished(ItemFishedEvent ev) {
        Player player = ev.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            if (this.testAsChance()) {
                FishingHook bobber = ev.getHookEntity();
                Level level = bobber.level();
                BlockPos pos = bobber.blockPosition();
                float luck = bobber.luck;
                boolean isLava = false;
                if (ev instanceof HaulingItemFishedEvent) {
                    HaulingItemFishedEvent haulingEv = (HaulingItemFishedEvent)ev;
                    luck = haulingEv.getLuck();
                    isLava = Fluids.LAVA.is(haulingEv.getHookEntity().getApplicableFluid());
                }
                float finalLuck = luck;
                boolean finalLava = isLava;
                HaulingSpawnPool.getTrapsPoolForLocation(level, pos, finalLava ? (FluidType)NeoForgeMod.LAVA_TYPE.value() : (FluidType)NeoForgeMod.WATER_TYPE.value()).flatMap(pool -> pool.getEntry(pl, finalLuck)).map(haulingEntity -> haulingEntity.apply(level, finalLava)).ifPresent(trapEntity -> {
                    double velX = pl.getX() - bobber.getX();
                    double velY = pl.getY() - bobber.getY();
                    double velZ = pl.getZ() - bobber.getZ();
                    trapEntity.setDeltaMovement(velX * 0.1, velY * 0.1 + Math.sqrt(Math.sqrt(velX * velX + velY * velY + velZ * velZ)) * 0.15, velZ * 0.1);
                    trapEntity.setPos(bobber.getX(), bobber.getY(), bobber.getZ());
                    level.addFreshEntity(trapEntity);
                });
            }
        }
    }

    private void handleSkillXpGain(PlayerChangeXpEvent ev) {
        if (ev.getSkill().type() == AoASkills.HAULING.get()) {
            ev.setXpGain(ev.getNewXpGain() * 1.1f);
        }
    }
}

