/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.farming;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class HarvestReplant
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(BlockEvent.BreakEvent.class, BlockEvent.BreakEvent::getPlayer, this.serverOnly(this::handleBlockBreak)));

    public HarvestReplant(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.HARVEST_REPLANT.get(), skill, data);
    }

    public HarvestReplant(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.HARVEST_REPLANT.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleBlockBreak(BlockEvent.BreakEvent ev) {
        BlockState state = ev.getState();
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            if (this.testAsChance()) {
                LevelAccessor level = ev.getLevel();
                BlockPos pos = ev.getPos();
                if (InventoryUtil.findItemForConsumption(ev.getPlayer(), stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)crop.getCloneItemStack((LevelReader)level, pos, state)), 1, true)) {
                    AoAScheduler.scheduleSyncronisedTask(() -> {
                        if (level.getBlockState(pos).isAir()) {
                            level.setBlock(pos, (BlockState)state.setValue((Property)crop.getAgeProperty(), (Comparable)Integer.valueOf(0)), 3);
                            if (!level.isClientSide()) {
                                PlayerUtil.giveXpToPlayer((ServerPlayer)ev.getPlayer(), (AoASkill)AoASkills.FARMING.get(), PlayerUtil.getTimeBasedXpForLevel(PlayerUtil.getLevel(ev.getPlayer(), (AoASkill)AoASkills.FARMING.get()), 3.0f), false);
                            }
                        }
                    }, 1);
                }
            }
        }
    }
}

