/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.farming;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class FertiliseFarmland
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerInteractEvent.RightClickBlock.class, this.serverOnly(this::handleBlockInteraction)));

    public FertiliseFarmland(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.FERTILISE_FARMLAND.get(), skill, data);
    }

    public FertiliseFarmland(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.FERTILISE_FARMLAND.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleBlockInteraction(PlayerInteractEvent.RightClickBlock ev) {
        Level world;
        BlockState state;
        ItemStack stack = ev.getItemStack();
        if (stack.getItem() == Items.BONE_MEAL && (state = (world = ev.getLevel()).getBlockState(ev.getPos())).getBlock() == Blocks.FARMLAND && WorldUtil.canModifyBlock((LevelAccessor)world, ev.getPos(), (Entity)ev.getEntity(), stack)) {
            world.setBlock(ev.getPos(), (BlockState)((Block)AoABlocks.FERTILISED_FARMLAND.get()).defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)((Integer)state.getValue((Property)FarmBlock.MOISTURE))), 3);
            PlayerUtil.giveXpToPlayer((ServerPlayer)ev.getEntity(), (AoASkill)AoASkills.FARMING.get(), PlayerUtil.getTimeBasedXpForLevel(PlayerUtil.getLevel(ev.getEntity(), (AoASkill)AoASkills.FARMING.get()), 1.0f), false);
            if (!ev.getEntity().isCreative()) {
                stack.shrink(1);
            }
        }
    }
}

