/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.farming;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.entity.AoANpcs;
import net.tslat.aoa3.content.entity.npc.ambient.DryadSpriteEntity;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;
import net.tslat.smartbrainlib.util.RandomUtil;

public class DryadSpriteSpawn
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(BlockEvent.BreakEvent.class, BlockEvent.BreakEvent::getPlayer, this.serverOnly(this::handleBlockBreak)));

    public DryadSpriteSpawn(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.DRYAD_SPRITE_SPAWN.get(), skill, data);
    }

    public DryadSpriteSpawn(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.DRYAD_SPRITE_SPAWN.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleBlockBreak(BlockEvent.BreakEvent ev) {
        LevelAccessor levelAccessor = ev.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (this.testAsChance()) {
                DryadSpriteEntity dryad;
                CropBlock crop;
                Block block = ev.getState().getBlock();
                if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).isMaxAge(ev.getState()) || this.getPlayer().getAbilities().instabuild) {
                    return;
                }
                BlockPos pos = ev.getPos();
                if (serverLevel.getBlockState(pos.above()).isAir() && (dryad = (DryadSpriteEntity)((Object)EntitySpawningUtil.spawnEntity(serverLevel, (EntityType)AoANpcs.DRYAD_SPRITE.get(), new Vec3((double)((float)pos.getX() + 0.5f), (double)pos.getY() + 0.1, (double)((float)pos.getZ() + 0.5f)), MobSpawnType.TRIGGERED))) != null) {
                    dryad.setOwner((ServerPlayer)this.getPlayer());
                    TELParticlePacket packet = new TELParticlePacket();
                    for (int i = 0; i < 20; ++i) {
                        packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (Entity)dryad).velocity(RandomUtil.randomScaledGaussianValue((double)0.02), RandomUtil.randomScaledGaussianValue((double)0.02), RandomUtil.randomScaledGaussianValue((double)0.02)));
                    }
                    packet.sendToAllPlayersTrackingEntity(serverLevel, (Entity)ev.getPlayer());
                }
            }
        }
    }
}

