/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.extraction;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.player.AoAPlayerKeybindListener;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;

public class HarvestSpeedBoost
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerEvent.BreakSpeed.class, this.serverOnly(this::handleHarvestSpeedCheck)), this.listener(PlayerTickEvent.Pre.class, this.serverOnly(this::handlePlayerTick)));
    private final float energyDrainPerTick;
    private final float costReductionPerLevel;
    private final float speedBoostMod;
    private boolean active = false;

    public HarvestSpeedBoost(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.HARVEST_SPEED_BOOST.get(), skill, data);
        this.energyDrainPerTick = GsonHelper.getAsFloat((JsonObject)data, (String)"energy_drain_per_tick");
        this.costReductionPerLevel = GsonHelper.getAsFloat((JsonObject)data, (String)"cost_reduction_per_level", (float)0.0f);
        this.speedBoostMod = GsonHelper.getAsFloat((JsonObject)data, (String)"speed_boost", (float)2.0f);
    }

    public HarvestSpeedBoost(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.HARVEST_SPEED_BOOST.get(), skill, data);
        this.energyDrainPerTick = data.getFloat("energy_drain_per_tick");
        this.costReductionPerLevel = data.getFloat("cost_reduction_per_level");
        this.speedBoostMod = data.getFloat("speed_boost");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + (this.costReductionPerLevel != 0.0f ? ".scaling" : "")), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.energyDrainPerTick * 20.0f, 2), NumberUtil.roundToNthDecimalPlace(this.costReductionPerLevel * 20.0f, 2)}));
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putFloat("energy_drain_per_tick", this.energyDrainPerTick);
            data.putFloat("cost_reduction_per_level", this.costReductionPerLevel);
            data.putFloat("speed_boost", this.speedBoostMod);
        }
        data.putBoolean("active", this.active);
        return data;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        super.receiveSyncData(data);
        this.active = data.getBoolean("active");
    }

    private void handleHarvestSpeedCheck(PlayerEvent.BreakSpeed ev) {
        if (this.active) {
            ev.setNewSpeed(ev.getNewSpeed() * this.speedBoostMod);
        }
    }

    @Override
    public void createKeybindListener(Consumer<AoAPlayerKeybindListener> consumer) {
        consumer.accept(new AoAPlayerKeybindListener(){

            @Override
            public AoAPlayerEventListener getEventListener() {
                return HarvestSpeedBoost.this;
            }

            @Override
            public int getKeycode() {
                return AoAKeybinds.ABILITY_ACTION.getKey().getValue();
            }

            @Override
            public boolean shouldSendKeyPress() {
                if (HarvestSpeedBoost.this.getPlayer().getAbilities().instabuild) {
                    return false;
                }
                return Minecraft.getInstance().gameMode.isDestroying() || HarvestSpeedBoost.this.active;
            }
        });
    }

    @Override
    public void handleKeyInput() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (this.active) {
                this.active = false;
            } else {
                if (player2.isCreative() || !player2.gameMode.isDestroyingBlock) {
                    return;
                }
                this.active = true;
            }
            this.activatedActionKey(player2);
            this.markForClientSync();
        }
    }

    private void handlePlayerTick(PlayerTickEvent.Pre ev) {
        if (!this.active) {
            return;
        }
        AoAResource.Instance energy = this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.ENERGY.get());
        Player player = this.getPlayer();
        if (!player.getAbilities().instabuild && !player.isSpectator() && energy.consume(energy.getPerTickRegen() + this.energyDrainPerTick - this.costReductionPerLevel * (float)this.skill.getLevel(true), true)) {
            if (player.level().getGameTime() % 10L == 0L) {
                this.activatedActionKey((ServerPlayer)player);
            }
        } else {
            this.active = false;
            this.markForClientSync();
        }
    }
}

