/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.extraction;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.Tags;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.PlayerSkillsLootModificationEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ItemUtil;

public class BonusMiningResult
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerSkillsLootModificationEvent.class, this.serverOnly(this::handleLootModification)));

    public BonusMiningResult(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.BONUS_MINING_RESULT.get(), skill, data);
    }

    public BonusMiningResult(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.BONUS_MINING_RESULT.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleLootModification(PlayerSkillsLootModificationEvent ev) {
        BlockState state = (BlockState)ev.getLootContext().getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state == null) {
            return;
        }
        if (!this.testAsChance()) {
            return;
        }
        if (!state.is(Tags.Blocks.ORES)) {
            return;
        }
        Item blockItem = state.getBlock().asItem();
        ObjectArrayList<ItemStack> loot = ev.getGeneratedLoot();
        if (blockItem != Items.AIR) {
            for (ItemStack stack : loot) {
                if (stack.getItem() != blockItem) continue;
                return;
            }
        }
        ObjectArrayList extraStacks = new ObjectArrayList();
        for (ItemStack stack : loot) {
            extraStacks.addAll(ItemUtil.increaseStackSize(stack, 1));
        }
        loot.addAll((Collection<ItemStack>)extraStacks);
    }
}

