/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.extraction;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.client.gui.container.SelectInventoryItemScreen;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.adventplayer.SyncAoAAbilityDataPacket;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.PlayerSkillsLootModificationEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.RegistryUtil;
import org.jetbrains.annotations.Nullable;

public class AutoHarvestingTrash
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerSkillsLootModificationEvent.class, this.serverOnly(this::handleLootModification)));
    @Nullable
    private Item consumingItem = null;

    public AutoHarvestingTrash(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.AUTO_HARVESTING_TRASH.get(), skill, data);
    }

    public AutoHarvestingTrash(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.AUTO_HARVESTING_TRASH.get(), skill, data);
        String itemId = data.getString("item");
        this.consumingItem = itemId.isEmpty() ? null : AoARegistries.ITEMS.getEntry((ResourceLocation)ResourceLocation.read((String)itemId).getOrThrow());
        this.updateDescription(Component.translatable((String)(Util.makeDescriptionId((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getKey(this.type())) + ".description")));
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        MutableComponent description = defaultDescription;
        if (this.consumingItem != null) {
            description = Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + ".item"), (Object[])new Object[]{Component.translatable((String)this.consumingItem.asItem().getDescriptionId()).withStyle(ChatFormatting.GRAY)});
        }
        super.updateDescription(description);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleLootModification(PlayerSkillsLootModificationEvent ev) {
        if (this.consumingItem != null && ev.getLootContext().getParamOrNull(LootContextParams.BLOCK_STATE) != null) {
            ev.getGeneratedLoot().removeIf(stack -> stack.getItem() == this.consumingItem);
        }
    }

    @Override
    public void loadFromNbt(CompoundTag data) {
        super.loadFromNbt(data);
        if (data.contains("item")) {
            this.consumingItem = AoARegistries.ITEMS.getEntry((ResourceLocation)ResourceLocation.read((String)data.getString("item")).getOrThrow());
            this.updateDescription(Component.translatable((String)(Util.makeDescriptionId((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getKey(this.type())) + ".description")));
            this.markForClientSync();
        }
    }

    @Override
    public CompoundTag saveToNbt() {
        CompoundTag data = super.saveToNbt();
        if (this.consumingItem != null) {
            data.putString("item", RegistryUtil.getId(this.consumingItem).toString());
        }
        return data;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        data.putString("item", this.consumingItem != null ? RegistryUtil.getId(this.consumingItem).toString() : "");
        return data;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        super.receiveSyncData(data);
        this.consumingItem = data.getString("item").equals("") ? null : AoARegistries.ITEMS.getEntry((ResourceLocation)ResourceLocation.read((String)data.getString("item")).getOrThrow());
        this.updateDescription(Component.translatable((String)(Util.makeDescriptionId((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getKey(this.type())) + ".description")));
    }

    @Override
    public void receiveInteractionDataFromClient(String data) {
        this.consumingItem = data.equals(RegistryUtil.getId(Items.AIR).toString()) ? null : AoARegistries.ITEMS.getEntry((ResourceLocation)ResourceLocation.read((String)data).getOrThrow());
        this.markForClientSync();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onGuiClick(int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        if (ClientOperations.isPressingCrouchKey()) {
            ClientHooks.pushGuiLayer((Minecraft)mc, (Screen)new SelectInventoryItemScreen(mc, this.consumingItem, item -> AoANetworking.sendToServer(new SyncAoAAbilityDataPacket(this, RegistryUtil.getId(item).toString()))));
            return false;
        }
        return super.onGuiClick(mouseX, mouseY);
    }
}

