/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.tslat.aoa3.client.player.AoAPlayerKeybindListener;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriptions;
import net.tslat.aoa3.library.constant.ScreenImageEffect;
import net.tslat.aoa3.player.PlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import org.jetbrains.annotations.ApiStatus;

public interface AoAPlayerEventListener {
    public List<DynamicEventSubscriber<? extends Event>> getEventSubscribers();

    default public <T extends Event> Optional<DynamicEventSubscriber<T>> getEventSubscriber(Class<T> eventClass) {
        for (DynamicEventSubscriber<? extends Event> subscriber : this.getEventSubscribers()) {
            if (subscriber.eventClass() != eventClass) continue;
            return Optional.of(subscriber);
        }
        return Optional.empty();
    }

    default public ListenerState getListenerState() {
        return ListenerState.ACTIVE;
    }

    default public boolean meetsRequirements() {
        return true;
    }

    public Player getPlayer();

    default public void reenable(boolean isInit) {
    }

    default public void disable(ListenerState reason, boolean isInit) {
    }

    default public boolean isStillValid() {
        return this.getListenerState() == ListenerState.ACTIVE;
    }

    default public void registerEventSubscribers() {
        if (this.isStillValid()) {
            DynamicEventSubscriptions.addListeners(this.getEventSubscribers());
        }
    }

    default public <T extends Event> DynamicEventSubscriber<T> listener(Class<T> eventClass, Function<T, Entity> entityGetter, Consumer<T> handler) {
        return DynamicEventSubscriber.of(eventClass, this.conditionally(ev -> entityGetter.apply(ev) == this.getPlayer(), handler), this::isStillValid);
    }

    default public <T extends PlayerEvent> DynamicEventSubscriber<T> listener(Class<T> eventClass, Consumer<T> handler) {
        return DynamicEventSubscriber.of(eventClass, this.conditionally(ev -> ev.getEntity() == this.getPlayer(), handler), this::isStillValid);
    }

    default public <T extends Event> Consumer<T> conditionally(Predicate<T> condition, Consumer<T> handler) {
        return ev -> {
            if (condition.test(ev)) {
                handler.accept(ev);
            }
        };
    }

    default public <T extends Event> Consumer<T> serverOnly(Consumer<T> handler) {
        return this.conditionally(ev -> !this.getPlayer().level().isClientSide, handler);
    }

    default public DynamicEventSubscriber<LivingIncomingDamageEvent> whenAttacking(Consumer<LivingIncomingDamageEvent> handler) {
        return this.listener(LivingIncomingDamageEvent.class, ev -> ev.getSource().getEntity(), handler);
    }

    default public DynamicEventSubscriber<LivingIncomingDamageEvent> whenTakingDamage(Consumer<LivingIncomingDamageEvent> handler) {
        return this.listener(LivingIncomingDamageEvent.class, LivingEvent::getEntity, handler);
    }

    default public DynamicEventSubscriber<LivingDamageEvent.Post> afterAttacking(Consumer<LivingDamageEvent.Post> handler) {
        return this.listener(LivingDamageEvent.Post.class, ev -> ev.getSource().getEntity(), handler);
    }

    default public DynamicEventSubscriber<LivingDamageEvent.Post> afterTakingDamage(Consumer<LivingDamageEvent.Post> handler) {
        return this.listener(LivingDamageEvent.Post.class, LivingEvent::getEntity, handler);
    }

    default public DynamicEventSubscriber<LivingDeathEvent> onEntityKill(Consumer<LivingDeathEvent> handler) {
        return DynamicEventSubscriber.of(LivingDeathEvent.class, ev -> {
            block0: {
                Player selfEntity = this.getPlayer();
                Iterator<Entity> iterator = EntityUtil.getAttackersForMob(ev.getEntity(), arg_0 -> AoAPlayerEventListener.lambda$onEntityKill$6(ev, (Entity)selfEntity, arg_0)).iterator();
                if (!iterator.hasNext()) break block0;
                Entity attacker = iterator.next();
                handler.accept((LivingDeathEvent)ev);
            }
        }, this::isStillValid);
    }

    default public void createKeybindListener(Consumer<AoAPlayerKeybindListener> consumer) {
    }

    default public void handleKeyInput() {
    }

    default public void activatedActionKey(ServerPlayer player) {
        new ScreenImageEffect(ScreenImageEffect.Type.ACTION_KEY_VIGNETTE).coloured(ColourUtil.makeARGB(0xFFFFFF, 127)).fullscreen(true).duration(10).sendToPlayer(player);
    }

    @ApiStatus.Internal
    public static void onKeyPress(Player player, List<String> abilityListeners) {
        PlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
        for (String str : abilityListeners) {
            AoAAbility.Instance ability = plData.getAbility(str);
            if (ability == null) continue;
            ability.handleKeyInput();
        }
    }

    private static /* synthetic */ boolean lambda$onEntityKill$6(LivingDeathEvent ev, Entity selfEntity, Entity entity) {
        return entity != ev.getEntity() && entity == selfEntity;
    }

    public static enum ListenerState {
        ACTIVE("active"),
        MANUALLY_DISABLED("disabled"),
        DEACTIVATED("deactivated"),
        REGION_LOCKED("region_locked"),
        REMOVED("region_locked");

        private final String id;

        private ListenerState(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static ListenerState fromId(String id) {
            return switch (id) {
                case "disabled" -> MANUALLY_DISABLED;
                case "deactivated" -> DEACTIVATED;
                case "active" -> ACTIVE;
                case "region_locked" -> REGION_LOCKED;
                case "removed" -> REMOVED;
                default -> DEACTIVATED;
            };
        }
    }
}

