/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object.explosion;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.library.object.AllDirections;
import net.tslat.aoa3.library.object.explosion.ExplosionInfo;
import net.tslat.aoa3.library.object.explosion.ExtendedExplosion;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.EntityUtil;
import org.jetbrains.annotations.Nullable;

public class StandardExplosion
extends ExtendedExplosion {
    protected EnumMap<AllDirections, Float> sectorPenetrationMap;

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder) {
        super(explosionInfo, level, exploder, indirectExploder);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder) {
        super(explosionInfo, level, exploder);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Vec3 position) {
        super(explosionInfo, level, exploder, position);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder, Vec3 position) {
        super(explosionInfo, level, exploder, indirectExploder, position);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, double x, double y, double z) {
        super(explosionInfo, level, exploder, x, y, z);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, double x, double y, double z) {
        super(explosionInfo, level, x, y, z);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, DamageSource damageSource, double x, double y, double z) {
        super(explosionInfo, level, damageSource, x, y, z);
    }

    public StandardExplosion(ExplosionInfo explosionInfo, ServerLevel level, @Nullable Entity exploder, @Nullable Entity indirectExploder, @Nullable DamageSource damageSource, double x, double y, double z) {
        super(explosionInfo, level, exploder, indirectExploder, damageSource, x, y, z);
    }

    @Override
    public int stepsPerTick() {
        return 1000;
    }

    @Override
    protected void doPreExplosionWork() {
        if (this.shouldDamageBlocks()) {
            this.sectorPenetrationMap = new EnumMap(AllDirections.class);
            float penetration = this.info.getPenetrationPower();
            BlockPos originPos = BlockPos.containing((Position)this.origin);
            float originFluidBlastResistance = this.level.getFluidState(originPos).getExplosionResistance((BlockGetter)this.level, originPos, (Explosion)this);
            if (originFluidBlastResistance > 0.0f) {
                penetration *= Math.max(0.0f, 0.6f - 0.1f * originFluidBlastResistance / 100.0f);
            }
            for (AllDirections direction : AllDirections.values()) {
                this.sectorPenetrationMap.put(direction, Float.valueOf(penetration * (float)this.random.randomValueBetween(0.5, 1.5)));
            }
        }
    }

    @Override
    protected ObjectArrayList<BlockPos> getAffectedBlocks() {
        if (!this.shouldDamageBlocks()) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList((int)Math.pow(this.info.getEffectiveRadius(), 2.0) * 4);
        this.info.getRadius().ifLeft(radius -> {
            for (int x = -((int)Math.floor(radius.floatValue())); x <= (int)Math.ceil(radius.floatValue()); ++x) {
                for (int y = -((int)Math.floor(radius.floatValue())); y <= (int)Math.ceil(radius.floatValue()); ++y) {
                    for (int z = -((int)Math.floor(radius.floatValue())); z <= (int)Math.ceil(radius.floatValue()); ++z) {
                        BlockPos pos;
                        if (!(((float)x + 0.5f) * ((float)x + 0.5f) + ((float)y + 0.5f) * ((float)y + 0.5f) + ((float)z + 0.5f) * ((float)z + 0.5f) < radius.floatValue() * radius.floatValue()) || !this.level.isInWorldBounds(pos = BlockPos.containing((double)((double)x + this.origin.x), (double)((double)y + this.origin.y), (double)((double)z + this.origin.z))) || this.level.getBlockState(pos).isAir()) continue;
                        list.add((Object)pos);
                    }
                }
            }
        }).ifRight(squareRadius -> {
            BlockPos originPos = BlockPos.containing((Position)this.origin);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)originPos.subtract(squareRadius.toVec3i()), (BlockPos)originPos.offset(squareRadius.toVec3i()))) {
                if (!this.level.isInWorldBounds(pos)) continue;
                list.add((Object)pos);
            }
        });
        list.sort(Comparator.comparingDouble(pos -> pos.distToCenterSqr((Position)this.origin)));
        return list;
    }

    @Override
    protected void filterAffectedBlocksAndEntities() {
        BlockPos pos2;
        ObjectListIterator objectListIterator = this.toBlow.iterator();
        while (objectListIterator.hasNext() && this.doBlockDamage(pos2 = (BlockPos)objectListIterator.next())) {
        }
        this.toBlow.removeIf(pos -> !this.affectedBlocks.containsKey(pos));
    }

    @Override
    protected void impactEntities() {
        for (Entity entity : this.affectedEntities) {
            if (this.info.isEntityDamaging() || this.info.isKnockbackEntities()) {
                double impactPercent = StandardExplosion.getSeenPercent((Vec3)this.origin, (Entity)entity);
                if (this.info.isEntityDamaging()) {
                    float distModifier = (float)Math.pow(EntityUtil.getEntityCenter(entity).distanceTo(this.origin), 0.5);
                    float damage = this.info.getBaseDamage() * (1.0f / distModifier);
                    damage *= this.info.calculateEntityDamageModifier(this, entity);
                    damage = (float)((double)damage * impactPercent);
                    damage = Math.min(this.info.getBaseDamage(), damage);
                    entity.hurt(this.damageSource, damage);
                }
                if (this.info.isKnockbackEntities() && entity.isPushable()) {
                    Vec3 dist = entity.position().subtract(this.origin).normalize();
                    double knockback = (double)this.info.getBaseKnockback() * impactPercent;
                    knockback *= (double)this.info.calculateKnockbackModifier(this, entity);
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        knockback *= 1.0 - AttributeUtil.getAttributeValue(livingEntity, (Holder<Attribute>)Attributes.EXPLOSION_KNOCKBACK_RESISTANCE);
                    }
                    dist.multiply(knockback, knockback, knockback);
                    entity.setDeltaMovement(entity.getDeltaMovement().add(EventHooks.getExplosionKnockback((Level)this.level, (Explosion)this, (Entity)entity, (Vec3)dist)));
                }
            }
            this.info.entityImpacted(this, entity);
        }
    }

    protected boolean doBlockDamage(BlockPos pos) {
        Vec3 posCenter = Vec3.atCenterOf((Vec3i)pos);
        AllDirections sector = AllDirections.byAngle(this.origin.subtract(posCenter).normalize());
        float sectorPenetration = this.sectorPenetrationMap.get((Object)sector).floatValue();
        if (sectorPenetration <= 0.0f) {
            return true;
        }
        BlockState state = this.level.getBlockState(pos);
        if (state.isAir()) {
            return true;
        }
        Optional blastResistance = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, pos, state, this.level.getFluidState(pos));
        if (blastResistance.isEmpty()) {
            return true;
        }
        if (!this.info.shouldAffectBlock(this, state, pos) || !this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, pos, state, (this.info.getBaseDamage() + this.info.getEffectiveRadius()) / 2.0f)) {
            float remainingPenetration = Math.max(0.0f, sectorPenetration - ((Float)blastResistance.get()).floatValue() / 5.0f);
            this.sectorPenetrationMap.put(sector, Float.valueOf(remainingPenetration));
            if (remainingPenetration > 0.0f) {
                return true;
            }
            for (float value : this.sectorPenetrationMap.values()) {
                if (!(value > 0.0f)) continue;
                return true;
            }
            return false;
        }
        float specificPenetration = sectorPenetration * this.info.calculateBlockDamageModifier(this, state, pos);
        float remainingPenetration = sectorPenetration;
        BlockPos immutablePos = pos.immutable();
        if (specificPenetration <= ((Float)blastResistance.get()).floatValue()) {
            if (this.random.fiftyFifty()) {
                remainingPenetration *= 0.5f;
            }
        } else {
            remainingPenetration = sectorPenetration - ((Float)blastResistance.get()).floatValue();
            this.affectedBlocks.put((Object)immutablePos, (Object)state);
        }
        this.sectorPenetrationMap.put(sector, Float.valueOf(Math.max(0.0f, remainingPenetration)));
        if (remainingPenetration > 0.0f) {
            return true;
        }
        for (float value : this.sectorPenetrationMap.values()) {
            if (!(value > 0.0f)) continue;
            return true;
        }
        return false;
    }
}

