/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomEntryPool<T, P>
implements Collection<T> {
    protected final RandomUtil.EasyRandom random;
    protected final List<PoolEntry<T, P>> entries;

    public RandomEntryPool() {
        this(RandomSource.create());
    }

    public RandomEntryPool(RandomSource random) {
        this((List<PoolEntry<T, P>>)new ObjectArrayList(), random);
    }

    protected RandomEntryPool(List<PoolEntry<T, P>> entries, RandomSource random) {
        this.entries = entries;
        this.random = new RandomUtil.EasyRandom(random);
    }

    public RandomEntryPool<T, P> add(T entry, int weight) {
        return this.add(entry, obj -> true, weight);
    }

    public RandomEntryPool<T, P> add(T entry, Predicate<P> validationPredicate, int weight) {
        return this.add(entry, validationPredicate, weight, 0.0f);
    }

    public RandomEntryPool<T, P> add(T entry, Predicate<P> validationPredicate, int weight, float weightMod) {
        return this.add(new PoolEntry<T, P>(entry, weight, weightMod, validationPredicate));
    }

    public RandomEntryPool<T, P> add(PoolEntry<T, P> entry) {
        this.entries.add(entry);
        return this;
    }

    public Optional<T> getEntry(@NotNull P predicateInput) {
        return this.getEntry(predicateInput, 0.0f);
    }

    public Optional<T> getEntry(@NotNull P predicateInput, float weightModifierMultiplier) {
        return this.getEntryRaw(predicateInput, weightModifierMultiplier).map(PoolEntry::get);
    }

    public Optional<PoolEntry<T, P>> getEntryRaw(@NotNull P predicateInput) {
        return this.getEntryRaw(predicateInput, 0.0f);
    }

    public Optional<PoolEntry<T, P>> getEntryRaw(@NotNull P predicateInput, float weightModifierMultiplier) {
        return Optional.ofNullable(this.selectEntry(predicateInput, weightModifierMultiplier));
    }

    public RandomEntryPool<T, P> getFilteredView(P predicateInput) {
        ImmutableList.Builder entries = new ImmutableList.Builder();
        for (PoolEntry<T, P> entry : this.entries) {
            if (!entry.test(predicateInput)) continue;
            entries.add(entry);
        }
        return new RandomEntryPool<T, P>(entries.build(), RandomSource.create());
    }

    public Stream<Optional<T>> getEntries(P predicateInput, float weightModifierMultiplier) {
        return this.getEntriesRaw(predicateInput, weightModifierMultiplier).map(optional -> optional.map(PoolEntry::get));
    }

    public Stream<Optional<PoolEntry<T, P>>> getEntriesRaw(P predicateInput, float weightModifierMultiplier) {
        Supplier filteredView = Suppliers.memoize(() -> this.getFilteredView(predicateInput));
        Supplier mappedWeights = Suppliers.memoize(() -> RandomEntryPool.lambda$getEntriesRaw$3((java.util.function.Supplier)filteredView, weightModifierMultiplier));
        return Stream.generate(() -> RandomEntryPool.lambda$getEntriesRaw$4((java.util.function.Supplier)filteredView, (java.util.function.Supplier)mappedWeights));
    }

    @Nullable
    private PoolEntry<T, P> selectEntry(@NotNull P predicateInput, float weightModifierMultiplier) {
        RandomEntryPool<T, P> filteredView = this.getFilteredView(predicateInput);
        if (filteredView.isEmpty()) {
            return null;
        }
        if (filteredView.entries.size() == 1) {
            return filteredView.entries.getFirst();
        }
        return filteredView.selectEntry(filteredView.mapPoolWeights(weightModifierMultiplier));
    }

    @Nullable
    private PoolEntry<T, P> selectEntry(IntObjectPair<int[]> mappedWeights) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.entries.size() == 1) {
            return this.entries.getFirst();
        }
        int selection = this.random.randomNumberUpTo(mappedWeights.leftInt());
        for (int i = 0; i < this.entries.size(); ++i) {
            if ((selection -= ((int[])mappedWeights.right())[i]) > 0) continue;
            return this.entries.get(i);
        }
        return null;
    }

    private IntObjectPair<int[]> mapPoolWeights(float weightModifierMultiplier) {
        int totalWeight = 0;
        int[] mappedWeights = new int[this.entries.size()];
        for (int i = 0; i < this.entries.size(); ++i) {
            mappedWeights[i] = this.entries.get(i).getEffectiveWeight(weightModifierMultiplier);
            totalWeight += mappedWeights[i];
        }
        return IntObjectPair.of((int)totalWeight, (Object)mappedWeights);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean contains(Object object) {
        for (PoolEntry<T, P> entry : this.entries) {
            if (!entry.get().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return RandomEntryPool.this.entries.size() > this.index;
            }

            @Override
            public T next() {
                return RandomEntryPool.this.entries.get(this.index++).get();
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] array = new Object[this.entries.size()];
        for (int i = 0; i < this.entries.size(); ++i) {
            array[i] = this.entries.get(i).get();
        }
        return array;
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] array) {
        if (array.length < this.entries.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.entries.size());
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            array[i] = this.entries.get(i).get();
        }
        return array;
    }

    @Override
    public boolean add(T entry) {
        throw new UnsupportedOperationException("Unweighted add operation not supported, use the overload that takes a weight value");
    }

    @Override
    public boolean remove(Object object) {
        Iterator<PoolEntry<T, P>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            PoolEntry<T, P> entry = iterator.next();
            if (!entry.get().equals(object)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object object : collection) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Unweighted add operation not supported, use the overload that takes a weight value");
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        boolean modified = false;
        for (Object object : collection) {
            if (!this.remove(object)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        int size = this.size();
        this.entries.removeIf(entry -> !collection.contains(entry.get()));
        return this.size() != size;
    }

    public String toString() {
        return "GenericEntryPool{entries=" + String.valueOf(this.entries) + "}";
    }

    private static /* synthetic */ Optional lambda$getEntriesRaw$4(java.util.function.Supplier filteredView, java.util.function.Supplier mappedWeights) {
        return Optional.ofNullable(((RandomEntryPool)filteredView.get()).selectEntry((IntObjectPair<int[]>)((IntObjectPair)mappedWeights.get())));
    }

    private static /* synthetic */ IntObjectPair lambda$getEntriesRaw$3(java.util.function.Supplier filteredView, float weightModifierMultiplier) {
        return ((RandomEntryPool)filteredView.get()).mapPoolWeights(weightModifierMultiplier);
    }

    public record PoolEntry<T, P>(T value, int weight, float weightMod, Predicate<P> validationPredicate) {
        public T get() {
            return this.value;
        }

        public int getEffectiveWeight(float weightModValue) {
            return this.weight + (int)(this.weightMod * weightModValue);
        }

        public boolean test(P predicateObj) {
            return this.validationPredicate.test(predicateObj);
        }
    }
}

