/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;

public class GenericItemStackHandler
extends ItemStackHandler {
    public GenericItemStackHandler() {
    }

    public GenericItemStackHandler(int size) {
        super(size);
    }

    public GenericItemStackHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public NonNullList<ItemStack> getAllStacks() {
        return this.stacks;
    }

    public void clear() {
        this.stacks.clear();
        this.allContentsChanged();
    }

    public void allContentsChanged() {
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.onContentsChanged(i);
        }
    }

    public void dropContentsInWorld(Level level, Vec3 pos) {
        for (ItemStack stack : this.stacks) {
            level.addFreshEntity((Entity)new ItemEntity(level, pos.x, pos.y, pos.z, stack));
        }
        this.clear();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("Contents", 10)) {
            this.stacks.clear();
            super.deserializeNBT(provider, nbt.getCompound("Contents"));
        }
    }
}

