/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.constant;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public enum BossDropsScheme {
    ON_GROUND(BossDropsScheme::onGroundDistributor),
    LAST_PLAYER_TO_HIT(BossDropsScheme::lastPlayerToHitDistributor),
    MOST_DAMAGING_PLAYER(BossDropsScheme::mostDamagingPlayerDistributor),
    SPLIT_BETWEEN_PLAYERS(BossDropsScheme::splitBetweenPlayersDistributor);

    private final Consumer<LivingDropsEvent> dropsEventConsumer;

    private BossDropsScheme(Consumer<LivingDropsEvent> dropsEventConsumer) {
        this.dropsEventConsumer = dropsEventConsumer;
    }

    public void handleDrops(LivingDropsEvent event) {
        this.dropsEventConsumer.accept(event);
    }

    private static void onGroundDistributor(LivingDropsEvent ev) {
    }

    private static void lastPlayerToHitDistributor(LivingDropsEvent ev) {
        Player attacker;
        List combatEntries = ev.getEntity().getCombatTracker().entries;
        if (combatEntries.isEmpty() && (attacker = PlayerUtil.getPlayerOrOwnerIfApplicable(ev.getSource().getEntity())) instanceof Player) {
            Player player = attacker;
            BossDropsScheme.giveDropsToPlayer(player, ev.getDrops().iterator());
            return;
        }
        for (int i = combatEntries.size() - 1; i >= 0; --i) {
            Entity attacker2 = ((CombatEntry)combatEntries.get(i)).source().getEntity();
            if (!(attacker2 instanceof Player)) continue;
            Player player = (Player)attacker2;
            BossDropsScheme.giveDropsToPlayer(player, ev.getDrops().iterator());
            return;
        }
    }

    private static void mostDamagingPlayerDistributor(LivingDropsEvent ev) {
        LivingEntity killer = ev.getEntity().getKillCredit();
        if (killer == null) {
            killer = PlayerUtil.getPlayerOrOwnerIfApplicable(ev.getSource().getEntity());
        }
        if (killer instanceof Player) {
            Player player = (Player)killer;
            BossDropsScheme.giveDropsToPlayer(player, ev.getDrops().iterator());
        }
    }

    private static void splitBetweenPlayersDistributor(LivingDropsEvent ev) {
        ObjectOpenHashSet players = new ObjectOpenHashSet();
        for (Entity attacker : EntityUtil.getAttackersForMob(ev.getEntity(), null)) {
            Player pl = PlayerUtil.getPlayerOrOwnerIfApplicable(attacker);
            if (pl == null) continue;
            players.add(pl);
        }
        if (players.size() == 0) {
            ev.setCanceled(true);
            return;
        }
        if (players.size() == 1) {
            BossDropsScheme.giveDropsToPlayer((Player)players.iterator().next(), ev.getDrops().iterator());
            return;
        }
        ObjectArrayList drops = new ObjectArrayList(ev.getDrops().size());
        int totalItems = 0;
        for (ItemEntity entity : ev.getDrops()) {
            if (entity.getItem().isEmpty()) continue;
            drops.add(entity.getItem());
        }
        Collections.shuffle(drops);
        ev.getDrops().clear();
        for (ItemStack stack : drops) {
            totalItems += stack.getCount();
        }
        Object2IntOpenHashMap messages = new Object2IntOpenHashMap();
        int perPlayerDrops = Math.max(1, totalItems / players.size());
        int playerDropCount = 0;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (!drops.isEmpty() && !players.isEmpty()) {
            int dropIndex = ((Random)random).nextInt(drops.size());
            ItemStack drop = (ItemStack)drops.get(dropIndex);
            Player player = (Player)players.iterator().next();
            int amount = 1 + ((Random)random).nextInt(Math.min(drop.getCount(), perPlayerDrops - playerDropCount));
            playerDropCount += amount;
            Component displayName = drop.getHoverName();
            if (amount == drop.getCount()) {
                if (!player.getInventory().add(drop)) {
                    players.remove(player);
                    playerDropCount = 0;
                    for (Object2IntMap.Entry entry : messages.object2IntEntrySet()) {
                        player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.drops"), ChatFormatting.GREEN, new Component[]{Component.literal((String)String.valueOf(entry.getIntValue())), (Component)entry.getKey()}));
                    }
                    continue;
                }
                messages.compute((Object)displayName, (name, count) -> count != null ? count + amount : amount);
                drops.remove(dropIndex);
            } else {
                ItemStack newStack = drop.copy();
                drop.setCount(drop.getCount() - amount);
                newStack.setCount(amount);
                if (!player.getInventory().add(newStack)) {
                    players.remove(player);
                    playerDropCount = 0;
                    for (Object2IntMap.Entry entry : messages.object2IntEntrySet()) {
                        player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.drops"), ChatFormatting.GREEN, new Component[]{Component.literal((String)String.valueOf(entry.getIntValue())), (Component)entry.getKey()}));
                    }
                    continue;
                }
                messages.compute((Object)displayName, (name, count) -> count != null ? count + amount : amount);
            }
            if (playerDropCount < perPlayerDrops) continue;
            players.remove(player);
            playerDropCount = 0;
        }
        if (!players.isEmpty()) {
            Player player = (Player)players.iterator().next();
            for (Object2IntMap.Entry entry : messages.object2IntEntrySet()) {
                player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.drops"), ChatFormatting.GREEN, new Component[]{Component.literal((String)String.valueOf(entry.getIntValue())), (Component)entry.getKey()}));
            }
        }
        LivingEntity entity = ev.getEntity();
        for (ItemStack stack : drops) {
            ev.getDrops().add(new ItemEntity(entity.level(), entity.getX(), entity.getY() + 0.5, entity.getZ(), stack));
        }
    }

    private static void giveDropsToPlayer(Player player, Iterator<ItemEntity> iterator) {
        Object2IntOpenHashMap messages = new Object2IntOpenHashMap();
        while (iterator.hasNext()) {
            ItemStack item = iterator.next().getItem();
            int amount = item.getCount();
            Component displayName = item.getHoverName();
            if (!player.getInventory().add(item)) break;
            messages.compute((Object)displayName, (name, count) -> count != null ? count + amount : amount);
            iterator.remove();
        }
        for (Object2IntMap.Entry entry : messages.object2IntEntrySet()) {
            player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.drops"), ChatFormatting.GREEN, new Component[]{Component.literal((String)String.valueOf(entry.getIntValue())), (Component)entry.getKey()}));
        }
    }
}

