/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.recipe.imbuing;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.gui.ingredients.RecipeSlot;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.client.render.custom.AoASkillRenderer;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.recipe.ImbuingRecipe;
import net.tslat.aoa3.integration.jei.ingredient.type.imbuing.ImbuingIngredientType;
import net.tslat.aoa3.integration.jei.recipe.ContainerRecipeCategory;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RenderUtil;

public class ImbuingRecipeCategory
extends ContainerRecipeCategory<ImbuingRecipe> {
    public static final RecipeType<ImbuingRecipe> RECIPE_TYPE = RecipeType.create((String)"aoa3", (String)"imbuing", ImbuingRecipe.class);

    public ImbuingRecipeCategory(IGuiHelper guiHelper, IModIdHelper idHelper, IIngredientManager ingredientHelper) {
        super(RECIPE_TYPE, guiHelper, idHelper, ingredientHelper);
    }

    public RecipeType<ImbuingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @Override
    protected ItemLike getRecipeCatalyst() {
        return AoABlocks.IMBUING_CHAMBER;
    }

    @Override
    protected int backgroundTextureU() {
        return 11;
    }

    @Override
    protected int backgroundTextureV() {
        return 11;
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return AdventOfAscension.id("textures/gui/containers/imbuing_chamber.png");
    }

    @Override
    protected IDrawable createBackgroundDrawRegion(IGuiHelper guiHelper, ResourceLocation backgroundTexture) {
        return guiHelper.createDrawable(backgroundTexture, this.backgroundTextureU(), this.backgroundTextureV(), 154, 64);
    }

    @Override
    protected void createRecipeLayout(IRecipeLayoutBuilder builder, ImbuingRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addIngredient((IIngredientType)ImbuingIngredientType.INSTANCE, (Object)new EnchantmentInstance((Holder)recipe.getEnchant().left(), recipe.getEnchant().rightInt()));
        builder.addSlot(RecipeIngredientRole.CATALYST, 139, 35).addItemStacks(AoARegistries.ITEMS.getAllRegisteredObjects().map(Item::getDefaultInstance).filter(recipe::canEnchantInput).toList());
        for (int slotIndex = 0; slotIndex < 6; ++slotIndex) {
            IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, slotIndex == 0 ? 17 : 19 + 19 * slotIndex, 35);
            if (slotIndex >= ingredients.size()) continue;
            slotBuilder.addIngredients((Ingredient)ingredients.get(slotIndex));
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, ImbuingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX < 140.0 || mouseY > 14.0) {
            return;
        }
        AoASkill.Instance skill = ClientPlayerDataManager.get().getSkill((AoASkill)AoASkills.IMBUING.get());
        tooltip.add((FormattedText)LocaleUtil.getLocaleMessage(LocaleUtil.createGuiLocaleKey("tooltip.skillReq"), ChatFormatting.LIGHT_PURPLE, new Component[0]));
        tooltip.add((FormattedText)LocaleUtil.getLocaleMessage(LocaleUtil.Keys.SKILL_REQUIREMENT, new Component[]{Component.literal((String)String.valueOf(recipe.getImbuingLevelReq())), skill.getName()}).withStyle(style -> style.withColor(skill.hasLevel(recipe.getImbuingLevelReq()) ? -8323296 : -40864)));
        if (recipe.getXpOverrideProvider().isPresent()) {
            FloatProvider xpProvider = recipe.getXpOverrideProvider().get();
            String minXp = NumberUtil.floorAndAppendSuffix(xpProvider.getMinValue(), true);
            String maxXp = NumberUtil.floorAndAppendSuffix(xpProvider.getMaxValue(), true);
            tooltip.add((FormattedText)LocaleUtil.getLocaleMessage(LocaleUtil.createGuiLocaleKey("misc.xpAmount"), ChatFormatting.YELLOW, new Component[]{Component.literal((String)(minXp + "-" + maxXp)), skill.getName()}));
        } else {
            tooltip.add((FormattedText)LocaleUtil.getLocaleMessage(LocaleUtil.createGuiLocaleKey("misc.xpAmount"), ChatFormatting.YELLOW, new Component[]{Component.literal((String)NumberUtil.roundToNthDecimalPlace(recipe.getXp((Player)Minecraft.getInstance().player), 2)), skill.getName()}));
        }
    }

    public void draw(ImbuingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int xOffset = -this.backgroundTextureU();
        int yOffset = -this.backgroundTextureU();
        PoseStack poseStack = guiGraphics.pose();
        RenderUtil.prepRenderTexture(this.getBackgroundTexture());
        RenderUtil.resetShaderColour();
        for (IRecipeSlotView slotView : recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT)) {
            Rect2i slotRegion = ((RecipeSlot)slotView).getRect();
            RenderUtil.renderCustomSizedTexture(guiGraphics.pose(), slotRegion.getX() - 1, slotRegion.getY() - 1, 26.0f, 166.0f, 18.0f, 18.0f, 256.0f, 256.0f);
        }
        Rect2i outputSlotRegion = ((RecipeSlot)recipeSlotsView.getSlotViews(RecipeIngredientRole.CATALYST).get(0)).getRect();
        RenderUtil.renderCustomSizedTexture(guiGraphics.pose(), outputSlotRegion.getX() - 5, outputSlotRegion.getY() - 5, 0.0f, 166.0f, 26.0f, 26.0f, 256.0f, 256.0f);
        if (recipe == null) {
            return;
        }
        Component enchant = Enchantment.getFullname((Holder)((Holder)recipe.getEnchant().left()), (int)recipe.getEnchant().rightInt());
        RenderUtil.drawRectangle(guiGraphics.pose(), 16 + xOffset, 59 + yOffset, Minecraft.getInstance().font.width((FormattedText)enchant) + 1, 10.0f, -872415232);
        RenderUtil.renderText(guiGraphics.pose(), enchant, 17 + xOffset, 60 + yOffset, 0xB2B2B2, RenderUtil.TextRenderType.NORMAL);
        AoASkillRenderer skillRenderer = AoAGuiElementRenderers.getSkillRenderer((AoASkill)AoASkills.IMBUING.get());
        AoASkill.Instance skill = ClientPlayerDataManager.get().getSkill((AoASkill)AoASkills.IMBUING.get());
        poseStack.pushPose();
        poseStack.translate(153.0f - (float)skillRenderer.guiRenderWidth(skill) * 0.5f, 1.0f, 0.0f);
        poseStack.scale(0.5f, 0.5f, 1.0f);
        skillRenderer.renderInHud(RenderContext.of(guiGraphics), skill, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), AoASkillRenderer.ProgressRenderType.None, false);
        poseStack.popPose();
    }
}

