/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.recipe;

import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.widgets.ISlottedWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerRecipeCategory<T>
implements IRecipeCategory<T> {
    protected final RecipeType<T> recipeType;
    protected final Component title;
    protected final IGuiHelper guiHelper;
    protected final IModIdHelper idHelper;
    protected final IIngredientManager ingredientManager;
    protected final IDrawable background;
    protected final IDrawable icon;

    public ContainerRecipeCategory(RecipeType<T> recipeType, IGuiHelper guiHelper, IModIdHelper idHelper, IIngredientManager ingredientManager) {
        this.recipeType = recipeType;
        this.title = LocaleUtil.getLocaleMessage(LocaleUtil.createGenericLocaleKey("recipe", recipeType.getUid().getPath()));
        this.guiHelper = guiHelper;
        this.idHelper = idHelper;
        this.ingredientManager = ingredientManager;
        this.background = this.createBackgroundDrawRegion(guiHelper, this.getBackgroundTexture());
        this.icon = guiHelper.createDrawableItemStack(this.getRecipeCatalyst().asItem().getDefaultInstance());
    }

    protected abstract IDrawable createBackgroundDrawRegion(IGuiHelper var1, ResourceLocation var2);

    protected abstract ItemLike getRecipeCatalyst();

    protected abstract int backgroundTextureU();

    protected abstract int backgroundTextureV();

    protected abstract void createRecipeLayout(IRecipeLayoutBuilder var1, T var2, IFocusGroup var3);

    protected abstract ResourceLocation getBackgroundTexture();

    public final void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        this.createRecipeLayout(new TextureBasedRecipeLayoutBuilder(builder, this.backgroundTextureV(), this.backgroundTextureV()), recipe, focuses);
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public record TextureBasedRecipeLayoutBuilder(IRecipeLayoutBuilder wrappedBuilder, int xOffset, int yOffset) implements IRecipeLayoutBuilder
    {
        @NotNull
        public IRecipeSlotBuilder addSlot(RecipeIngredientRole recipeIngredientRole, int x, int y) {
            return this.wrappedBuilder.addSlot(recipeIngredientRole, x - this.xOffset, y - this.yOffset);
        }

        public IRecipeSlotBuilder addSlot(RecipeIngredientRole role) {
            return this.wrappedBuilder.addSlot(role);
        }

        public IRecipeSlotBuilder addSlotToWidget(RecipeIngredientRole role, ISlottedWidgetFactory<?> widgetFactory) {
            return null;
        }

        public IIngredientAcceptor<?> addInvisibleIngredients(RecipeIngredientRole recipeIngredientRole) {
            return this.wrappedBuilder.addInvisibleIngredients(recipeIngredientRole);
        }

        public void moveRecipeTransferButton(int posX, int posY) {
            this.wrappedBuilder.moveRecipeTransferButton(posX - this.xOffset, posY - this.yOffset);
        }

        public void setShapeless() {
            this.wrappedBuilder.setShapeless();
        }

        public void setShapeless(int posX, int posY) {
            this.wrappedBuilder.setShapeless(posX - this.xOffset, posY - this.yOffset);
        }

        public void createFocusLink(IIngredientAcceptor<?> ... slots) {
            this.wrappedBuilder.createFocusLink(slots);
        }
    }
}

