/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.ingredient.type.imbuing;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;
import net.tslat.aoa3.client.render.AoAGuiElementRenderers;
import net.tslat.aoa3.client.render.custom.AoASkillRenderer;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.library.object.RenderContext;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;

public class ImbuingIngredientRenderer
implements IIngredientRenderer<EnchantmentInstance> {
    private AoASkillRenderer skillRenderer = null;

    public void render(GuiGraphics guiGraphics, EnchantmentInstance ingredient) {
        if (this.skillRenderer == null) {
            this.skillRenderer = AoAGuiElementRenderers.getSkillRenderer((AoASkill)AoASkills.IMBUING.get());
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.64f, 0.64f, 1.0f);
        this.skillRenderer.renderInGui(RenderContext.of(guiGraphics), ClientPlayerDataManager.get().getSkill((AoASkill)AoASkills.IMBUING.get()), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), 0, 0, AoASkillRenderer.ProgressRenderType.None, false);
        guiGraphics.pose().popPose();
    }

    public List<Component> getTooltip(EnchantmentInstance ingredient, TooltipFlag tooltipFlag) {
        ObjectArrayList tooltip = new ObjectArrayList();
        Holder enchant = ingredient.enchantment;
        ResourceLocation id = RegistryUtil.getRegistry((ResourceKey)Registries.ENCHANTMENT).getKey((Object)((Enchantment)enchant.value()));
        String enchantDescKey = "enchantment." + id.getNamespace() + "." + id.getPath() + ".desc";
        MutableComponent enchantDesc = LocaleUtil.getLocaleMessage(enchantDescKey);
        int enchantWeight = ((Enchantment)enchant.value()).getWeight();
        Rarity rarity = enchantWeight >= 10 ? Rarity.COMMON : (enchantWeight >= 5 ? Rarity.UNCOMMON : (enchantWeight >= 3 ? Rarity.RARE : Rarity.EPIC));
        tooltip.add(((MutableComponent)Enchantment.getFullname((Holder)enchant, (int)ingredient.level)).withStyle(rarity.getStyleModifier()));
        if (!enchantDesc.getString().equals(enchantDescKey)) {
            tooltip.add(enchantDesc);
        }
        if (tooltipFlag.isAdvanced()) {
            tooltip.add(Component.literal((String)id.toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    public Font getFontRenderer(Minecraft minecraft, EnchantmentInstance ingredient) {
        return Services.PLATFORM.getRenderHelper().getFontRenderer(minecraft, Items.ENCHANTED_BOOK.getDefaultInstance());
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }
}

