/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event.dynamic;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;

public final class DynamicEventSubscriptions {
    private static final ListMultimap<Class<? extends Event>, DynamicEventSubscriber<? extends Event>> LISTENERS = MultimapBuilder.hashKeys().arrayListValues().build();
    private static final List<DynamicEventSubscriber<? extends Event>> NEW_LISTENERS = new ObjectArrayList();

    public static void init() {
        NeoForge.EVENT_BUS.addListener(DynamicEventSubscriptions::addNewSubscribers);
    }

    public static void addListeners(DynamicEventSubscriber<? extends Event> ... subscribers) {
        DynamicEventSubscriptions.addListeners(List.of(subscribers));
    }

    public static void addListeners(Collection<? extends DynamicEventSubscriber<? extends Event>> subscribers) {
        NEW_LISTENERS.addAll(subscribers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNewSubscribers(ServerTickEvent.Post ev) {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        ListMultimap<Class<? extends Event>, DynamicEventSubscriber<? extends Event>> listMultimap = LISTENERS;
        synchronized (listMultimap) {
            for (DynamicEventSubscriber<? extends Event> subscriber : NEW_LISTENERS) {
                List listeners;
                if (!subscriber.isStillValid()) continue;
                Class<? extends Event> clazz = subscriber.eventClass();
                if (!LISTENERS.containsKey(clazz)) {
                    eventBus.addListener(clazz, event -> {
                        Iterator iterator = LISTENERS.get((Object)clazz).iterator();
                        while (iterator.hasNext()) {
                            DynamicEventSubscriber listener = (DynamicEventSubscriber)iterator.next();
                            if (!listener.isStillValid()) {
                                iterator.remove();
                                continue;
                            }
                            listener.accept(event);
                        }
                    });
                }
                if ((listeners = LISTENERS.get(clazz)).contains(subscriber)) continue;
                listeners.add(subscriber);
            }
        }
        NEW_LISTENERS.clear();
    }
}

