/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event.dynamic;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.neoforged.bus.api.Event;

public interface DynamicEventSubscriber<T extends Event>
extends Consumer<T> {
    public Class<T> eventClass();

    public boolean isStillValid();

    public static <T extends Event> DynamicEventSubscriber<T> of(Class<T> eventClass, Consumer<T> handler, BooleanSupplier isActive) {
        return new Impl<T>(eventClass, handler, isActive);
    }

    public record Impl<T extends Event>(Class<T> eventClass, Consumer<T> handler, BooleanSupplier activePredicate) implements DynamicEventSubscriber<T>
    {
        @Override
        public boolean isStillValid() {
            return this.activePredicate.getAsBoolean();
        }

        @Override
        public void accept(T t) {
            this.handler.accept(t);
        }
    }
}

