/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.data.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.util.ObjectUtil;
import org.apache.logging.log4j.Level;

public class MiscellaneousReloadListener
implements ResourceManagerReloadListener {
    public static final Map<Object, String> DATA = new Object2ObjectOpenHashMap();

    public void onResourceManagerReload(ResourceManager resourceManager) {
        try {
            Optional wornBook;
            DATA.clear();
            Minecraft mc = Minecraft.getInstance();
            String langCode = mc.options.languageCode;
            if (mc.getLanguageManager().getSelected() != null) {
                langCode = mc.getLanguageManager().getSelected();
            }
            if (!(wornBook = resourceManager.getResource(AdventOfAscension.id("misc/" + langCode + "/worn_book.txt"))).isPresent()) {
                return;
            }
            DATA.put(AoAItems.WORN_BOOK.get(), ObjectUtil.bufferedReaderToString(new BufferedReader(new InputStreamReader(((Resource)wornBook.get()).open(), StandardCharsets.UTF_8))));
        }
        catch (IOException ex) {
            Logging.logMessage(Level.ERROR, "Failed to retrieve AoA3 additional resources, skipping.", ex);
        }
    }
}

