/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.data.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public class AdventGuiThemeReloadListener
implements PreparableReloadListener {
    private static final ArrayList<AdventGuiTheme> THEMES = new ArrayList(7);
    private static int pointer = -1;

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return stage.wait((Object)Unit.INSTANCE).thenRunAsync(() -> this.handleResourcesReload(resourceManager, reloadProfiler));
    }

    private void handleResourcesReload(ResourceManager resourceManager, ProfilerFiller reloadProfiler) {
        THEMES.clear();
        HashMap<String, ResourceLocation[]> textures = new HashMap<String, ResourceLocation[]>();
        textures.put("default", new ResourceLocation[3]);
        for (ResourceLocation resourceLocation : resourceManager.listResources("textures/gui/adventgui/themes", path -> path.getPath().endsWith(".png")).keySet()) {
            int subfolderIndexEnd;
            int subfolderIndexStart = resourceLocation.getPath().indexOf("themes/") + 7;
            if (subfolderIndexStart == (subfolderIndexEnd = resourceLocation.getPath().lastIndexOf("/"))) continue;
            String theme = resourceLocation.getPath().substring(subfolderIndexStart, subfolderIndexEnd);
            ResourceLocation[] themeTextures = textures.getOrDefault(theme, new ResourceLocation[3]);
            switch (resourceLocation.getPath().substring(subfolderIndexEnd + 1)) {
                case "background.png": {
                    themeTextures[0] = resourceLocation;
                    break;
                }
                case "tab_buttons.png": {
                    themeTextures[1] = resourceLocation;
                    break;
                }
                case "overlay.png": {
                    themeTextures[2] = resourceLocation;
                }
            }
            textures.put(theme, themeTextures);
        }
        for (Map.Entry entry : textures.entrySet()) {
            ResourceLocation[] paths = (ResourceLocation[])entry.getValue();
            THEMES.add(new AdventGuiTheme((String)entry.getKey(), LocaleUtil.createGuiLocaleKey("adventGui.theme." + (String)entry.getKey()), paths[0], paths[1], paths[2]));
        }
    }

    public static AdventGuiTheme getNextTheme() {
        if (++pointer >= THEMES.size()) {
            pointer = 0;
        }
        return THEMES.get(pointer);
    }

    public static AdventGuiTheme setTheme(String name) {
        pointer = 0;
        for (int i = 0; i < THEMES.size(); ++i) {
            if (!StringUtil.toTitleCase(AdventGuiThemeReloadListener.THEMES.get((int)i).id).equals(name)) continue;
            pointer = i;
            break;
        }
        return THEMES.get(pointer);
    }

    public record AdventGuiTheme(String id, String nameLocale, ResourceLocation backgroundTexture, ResourceLocation menuButtonTexture, @Nullable ResourceLocation overlayTexture) {
        public AdventGuiTheme(String id, String nameLocale, @Nullable ResourceLocation backgroundTexture, @Nullable ResourceLocation menuButtonTexture, @Nullable ResourceLocation overlayTexture) {
            this.id = id;
            this.nameLocale = nameLocale;
            this.backgroundTexture = backgroundTexture == null ? AdventOfAscension.id("textures/gui/adventgui/themes/default/background.png") : backgroundTexture;
            this.menuButtonTexture = menuButtonTexture == null ? AdventOfAscension.id("textures/gui/adventgui/themes/default/tab_buttons.png") : menuButtonTexture;
            this.overlayTexture = overlayTexture;
        }
    }
}

