/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.spawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.tslat.smartbrainlib.util.RandomUtil;

public interface AoACustomSpawner<E extends Entity>
extends CustomSpawner {
    public static final Codec<GenericSettings> GENERIC_SETTINGS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IntProvider.CODEC.fieldOf("spawn_interval").forGetter(GenericSettings::spawnInterval), (App)IntProvider.CODEC.fieldOf("extra_delay_per_spawn").forGetter(GenericSettings::extraDelayPerSpawn), (App)Codec.FLOAT.fieldOf("chance_per_player").forGetter(GenericSettings::chancePerPlayer), (App)IntProvider.CODEC.fieldOf("spawn_attempts_per_player").forGetter(GenericSettings::spawnAttemptsPerPlayer), (App)Biome.LIST_CODEC.optionalFieldOf("in_biomes").forGetter(GenericSettings::inBiomes), (App)Biome.LIST_CODEC.optionalFieldOf("not_in_biomes").forGetter(GenericSettings::notInBiomes), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).listOf().xmap(Set::copyOf, List::copyOf).optionalFieldOf("in_dimensions").forGetter(GenericSettings::inDimensions), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).listOf().xmap(Set::copyOf, List::copyOf).optionalFieldOf("not_in_dimensions").forGetter(GenericSettings::notInDimensions), (App)SpawnData.CustomSpawnRules.CODEC.optionalFieldOf("spawn_rules").forGetter(GenericSettings::spawnRules), (App)Codec.BOOL.fieldOf("spawn_in_flat_world").forGetter(GenericSettings::spawnInSuperflat)).apply((Applicative)builder, GenericSettings::new));

    public boolean shouldAddToDimension(ServerLevel var1);

    public AoACustomSpawner<E> copy();

    public Type<E> getType();

    default public Heightmap.Types getHeightmapForSpawn(EntityType<E> entityType, ServerLevel level, RandomSource random, BlockPos pos) {
        return SpawnPlacements.getHeightmapType(entityType);
    }

    default public SpawnPlacementType getSpawnPlacementTypeForSpawn(EntityType<E> entityType, ServerLevel level, RandomSource random, BlockPos pos) {
        return SpawnPlacements.getPlacementType(entityType);
    }

    default public boolean canSpawnAt(EntityType<E> entityType, ServerLevel level, RandomSource random, BlockPos pos, SpawnPlacementType spawnPlacement) {
        return this.canSpawnInBiome(level, pos) && NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)level, (BlockPos)pos, (BlockState)level.getBlockState(pos), (FluidState)level.getFluidState(pos), entityType) && level.noCollision(entityType.getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5));
    }

    default public boolean canSpawnInBiome(ServerLevel level, BlockPos pos) {
        return true;
    }

    default public List<Pair<EntityType<E>, BlockPos>> findNearbySpawnPositions(ServerLevel level, RandomSource random, BlockPos centerPos, int minRadius, int maxRadius, int maxTries, Supplier<Optional<EntityType<E>>> entityTypeSupplier) {
        ObjectArrayList positions = new ObjectArrayList();
        RandomUtil.EasyRandom rand = new RandomUtil.EasyRandom(random);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        float radius = Math.max(maxRadius - minRadius, 0);
        for (int i = 0; i < maxTries; ++i) {
            entityTypeSupplier.get().ifPresent(arg_0 -> this.lambda$findNearbySpawnPositions$1(rand, radius, centerPos, level, mutablePos, random, (List)positions, arg_0));
        }
        return positions;
    }

    private /* synthetic */ void lambda$findNearbySpawnPositions$1(RandomUtil.EasyRandom rand, float radius, BlockPos centerPos, ServerLevel level, BlockPos.MutableBlockPos mutablePos, RandomSource random, List positions, EntityType entityType) {
        SpawnPlacementType spawnPlacement;
        double xAdjust = rand.randomValueBetween((double)(-radius), (double)radius);
        double zAdjust = rand.randomValueBetween((double)(-radius), (double)radius);
        int newX = (int)Math.floor((double)centerPos.getX() + xAdjust + (double)radius * Math.signum(xAdjust));
        int newZ = (int)Math.floor((double)centerPos.getZ() + zAdjust + (double)radius * Math.signum(zAdjust));
        if (level.dimensionType().hasCeiling()) {
            mutablePos.set(newX, Mth.randomBetweenInclusive((RandomSource)random, (int)level.getMinBuildHeight(), (int)level.getHeight(Heightmap.Types.WORLD_SURFACE, newX, newZ)), newZ);
            while (!level.getBlockState((BlockPos)mutablePos.move(Direction.DOWN)).isAir()) {
            }
        } else {
            mutablePos.set((Vec3i)level.getHeightmapPos(this.getHeightmapForSpawn(entityType, level, random, (BlockPos)mutablePos.set(newX, 0, newZ)), (BlockPos)mutablePos));
        }
        if ((spawnPlacement = this.getSpawnPlacementTypeForSpawn(entityType, level, random, (BlockPos)mutablePos)) == SpawnPlacementTypes.ON_GROUND) {
            while (level.getBlockState((BlockPos)mutablePos.move(Direction.DOWN)).isAir() && mutablePos.getY() > level.getMinBuildHeight()) {
            }
        }
        mutablePos.move(Direction.UP);
        if (this.canSpawnAt(entityType, level, random, (BlockPos)mutablePos, spawnPlacement)) {
            positions.add(Pair.of((Object)entityType, (Object)mutablePos.immutable()));
        }
    }

    public record GenericSettings(IntProvider spawnInterval, IntProvider extraDelayPerSpawn, float chancePerPlayer, IntProvider spawnAttemptsPerPlayer, Optional<HolderSet<Biome>> inBiomes, Optional<HolderSet<Biome>> notInBiomes, Optional<Set<ResourceKey<Level>>> inDimensions, Optional<Set<ResourceKey<Level>>> notInDimensions, Optional<SpawnData.CustomSpawnRules> spawnRules, boolean spawnInSuperflat) {
    }

    public record Type<E extends Entity>(MapCodec<? extends AoACustomSpawner<E>> codec) {
    }
}

