/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.nowhere;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.tslat.aoa3.advent.AoAResourceCaching;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.item.misc.summoning.BossTokenItem;
import net.tslat.aoa3.event.dimension.NowhereEvents;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.ObjectUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class NowhereBossArena {
    public static final Codec<NowhereBossArena> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("structure_id").forGetter(arena -> arena.structureId), (App)BlockPos.CODEC.fieldOf("arena_pos").forGetter(arena -> arena.structurePos), (App)Vec3.CODEC.listOf(1, Integer.MAX_VALUE).fieldOf("player_spawns").forGetter(arena -> arena.playerSpawnPoints), (App)Vec3.CODEC.listOf(1, Integer.MAX_VALUE).fieldOf("boss_spawns").forGetter(arena -> arena.bossSpawnPoints)).apply((Applicative)builder, NowhereBossArena::new));
    private static NowhereBossArena[] ARENAS = new NowhereBossArena[0];
    public final ResourceLocation structureId;
    private final BlockPos structurePos;
    private final List<Vec3> playerSpawnPoints;
    private final List<Vec3> bossSpawnPoints;
    private Structure structure = null;
    private StructureStart structureStart = null;
    private AABB structureBounds = null;

    public NowhereBossArena(ResourceLocation structureId, BlockPos structurePos, List<Vec3> playerSpawnPoints, List<Vec3> bossSpawnPoints) {
        this.structureId = structureId;
        this.structurePos = structurePos;
        this.playerSpawnPoints = playerSpawnPoints;
        this.bossSpawnPoints = bossSpawnPoints;
    }

    @Nullable
    public static NowhereBossArena getFreeArena(ServerLevel level) {
        ObjectUtil.shuffleArray(ARENAS, level.getRandom());
        for (NowhereBossArena arena : ARENAS) {
            if (!arena.checkAndClear(level)) continue;
            return arena;
        }
        return null;
    }

    @Nullable
    public static NowhereBossArena getClosestArena(ServerLevel level, Vec3 pos) {
        if (!NowhereEvents.isInBossRegion(BlockPos.containing((Position)pos))) {
            return null;
        }
        NowhereBossArena closest = null;
        double dist = Double.MAX_VALUE;
        for (NowhereBossArena arena : ARENAS) {
            AABB bounds = arena.getStructureBounds(level);
            if (bounds == null) continue;
            double testDist = bounds.getCenter().distanceToSqr(pos);
            if (testDist < 2500.0) {
                return arena;
            }
            if (!(testDist < dist)) continue;
            dist = testDist;
            closest = arena;
        }
        return closest;
    }

    public boolean checkAndClear(ServerLevel level) {
        AABB bounds = this.getStructureBounds(level);
        if (bounds == null) {
            return false;
        }
        if (!level.isLoaded(BlockPos.containing((Position)bounds.getCenter()))) {
            return true;
        }
        List<Player> players = this.getPlayersInside(level, bounds);
        List<Entity> entities = this.getEntitiesInside(level, bounds);
        if (!players.isEmpty()) {
            boolean keepArena = false;
            for (Entity entity : entities) {
                if (!(entity instanceof ItemEntity) && !entity.getType().is(Tags.EntityTypes.BOSSES)) continue;
                keepArena = true;
                break;
            }
            if (keepArena) {
                return false;
            }
            for (Player player : players) {
                AoAScheduler.scheduleSyncronisedTask(() -> {
                    ServerPlayer pl = (ServerPlayer)player;
                    PlayerUtil.resetToDefaultStatus(pl);
                    pl.connection.teleport(17.5, 452.5, 3.5, 0.0f, pl.getXRot());
                    InventoryUtil.clearItems(pl, new ItemLike[]{AoAItems.RETURN_CRYSTAL});
                    PlayerUtil.getAdventPlayer((ServerPlayer)pl).storage.returnStoredItems();
                }, 1);
            }
        }
        for (Entity entity : entities) {
            entity.discard();
        }
        return true;
    }

    public void placePlayersAndBoss(ServerLevel level, List<Player> players, Predicate<Player> playerStillValid, ItemStack stack, EntityType<?> entityType, BossTokenItem.SpawningFunction bossFunction) {
        if (players.isEmpty()) {
            return;
        }
        StructureStart structureStart = this.getStructureStart(level);
        if (structureStart == null) {
            return;
        }
        AoAScheduler.scheduleSyncronisedTask(() -> {
            Object boss;
            SoundBuilder soundBuilder;
            boolean spawnBoss = false;
            Entity entity = entityType.create((Level)level);
            SoundBuilder soundBuilder2 = soundBuilder = entity instanceof AoABoss && ((AoABoss)(boss = (AoABoss)entity)).getMusic() != null ? new SoundBuilder(((AoABoss)boss).getMusic()).isMusic() : null;
            if (entity != null) {
                entity.discard();
            }
            for (Player player : players) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (playerStillValid.test((Player)serverPlayer)) {
                    Vec3 pos = (Vec3)RandomUtil.getRandomSelection(this.playerSpawnPoints);
                    spawnBoss = true;
                    serverPlayer.connection.teleport(pos.x, pos.y, pos.z, 0.0f, 0.0f);
                    InventoryUtil.giveItemTo(serverPlayer, AoAItems.RETURN_CRYSTAL);
                    serverPlayer.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.bossWarning"), ChatFormatting.GREEN, new Component[0]));
                } else {
                    serverPlayer.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.tooFar"), ChatFormatting.RED, new Component[0]));
                }
                if (soundBuilder == null) continue;
                soundBuilder.include(player);
            }
            if (spawnBoss) {
                AABB bounds = this.getStructureBounds(level);
                AoAScheduler.scheduleSyncronisedTask(() -> this.getEntitiesInside(level, bounds).forEach(entity2 -> {
                    if (!(entity2 instanceof Player) && !(entity2 instanceof ItemEntity)) {
                        entity2.discard();
                    }
                }), 1);
                AoAScheduler.scheduleSyncronisedTask(() -> {
                    if (soundBuilder != null) {
                        soundBuilder.execute();
                    }
                }, 40);
                AoAScheduler.scheduleSyncronisedTask(() -> {
                    int playerCount = this.getPlayersInside(level, bounds).size();
                    if (playerCount > 0) {
                        bossFunction.spawn(level, this.getRandomBossSpawn(), stack, playerCount);
                    }
                }, 140);
            }
        }, 100);
        for (Player player : players) {
            player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("nowhere.boss.teleportWarning"), ChatFormatting.GOLD, new Component[0]));
        }
    }

    @Nullable
    private Structure getStructure(ServerLevel level) {
        if (this.structure != null) {
            return this.structure;
        }
        this.structure = (Structure)((Registry)level.registryAccess().registry(Registries.STRUCTURE).get()).get(this.structureId);
        return this.structure;
    }

    @Nullable
    private StructureStart getStructureStart(ServerLevel level) {
        if (this.structureStart != null) {
            return this.structureStart;
        }
        Structure structure = this.getStructure(level);
        if (structure == null) {
            return null;
        }
        this.structureStart = level.structureManager().getStructureAt(this.structurePos, structure);
        return this.structureStart;
    }

    @Nullable
    public AABB getStructureBounds(ServerLevel level) {
        if (this.structureBounds != null) {
            return this.structureBounds;
        }
        StructureStart structureStart = this.getStructureStart(level);
        if (structureStart == null) {
            return null;
        }
        this.structureBounds = AABB.of((BoundingBox)structureStart.getBoundingBox()).inflate(50.0);
        return this.structureBounds;
    }

    public List<Player> getPlayersInside(ServerLevel level) {
        AABB bounds = this.getStructureBounds(level);
        if (bounds == null) {
            return List.of();
        }
        return this.getPlayersInside(level, bounds);
    }

    public List<Player> getPlayersInside(ServerLevel level, AABB bounds) {
        return EntityRetrievalUtil.getPlayers((Level)level, (AABB)bounds);
    }

    public List<Entity> getEntitiesInside(ServerLevel level) {
        AABB bounds = this.getStructureBounds(level);
        if (bounds == null) {
            return List.of();
        }
        return this.getEntitiesInside(level, bounds);
    }

    public List<Entity> getEntitiesInside(ServerLevel level, AABB bounds) {
        return EntityRetrievalUtil.getEntities((Level)level, (AABB)bounds, entity -> !(entity instanceof Player));
    }

    public Vec3 getRandomBossSpawn() {
        return (Vec3)RandomUtil.getRandomSelection(this.bossSpawnPoints);
    }

    static {
        AoAResourceCaching.onDataReload(registryAccess -> {
            ARENAS = (NowhereBossArena[])registryAccess.registryOrThrow(AoARegistries.NOWHERE_BOSS_ARENAS_REGISTRY_KEY).stream().toArray(NowhereBossArena[]::new);
        });
        AoAResourceCaching.onClientLogout(() -> {
            ARENAS = null;
        });
    }
}

