/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.worldgen.AoAStructureTypes;
import net.tslat.aoa3.content.world.gen.structure.AoAJigsawAssembler;
import net.tslat.aoa3.content.world.gen.structure.AoAStructure;

public class TopAlignedStructure
extends AoAStructure {
    protected int nextGenHeight = 0;
    public static final MapCodec<TopAlignedStructure> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group(AoAStructure.Settings.aoaSettings()).apply((Applicative)codec, TopAlignedStructure::new));

    public TopAlignedStructure(AoAStructure.Settings settings) {
        super(settings);
    }

    @Override
    public StructureType<? extends AoAStructure> type() {
        return (StructureType)AoAStructureTypes.TOP_ALIGNED.get();
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext genContext) {
        ChunkPos chunkpos = genContext.chunkPos();
        this.nextGenHeight = this.settings.startHeight().sample((RandomSource)genContext.random(), new WorldGenerationContext(genContext.chunkGenerator(), genContext.heightAccessor()));
        BlockPos blockpos = new BlockPos(chunkpos.getMinBlockX(), this.nextGenHeight, chunkpos.getMinBlockZ());
        return this.assembler.addPieces(genContext, this.settings.startPool(), this.settings.startJigsawName(), this.settings.maxPieces(), blockpos, this.settings.startHeightmap(), 128, this.settings.liquidSettings());
    }

    @Override
    protected AoAJigsawAssembler getJigsawAssembler() {
        return new AoAJigsawAssembler(){

            @Override
            protected Optional<Structure.GenerationStub> buildGenerationStub(PoolElementStructurePiece startPiece, BoundingBox startPieceBounds, Structure.GenerationContext genContext, int startX, int startY, int startZ, int maxPieces, int maxRadius, LiquidSettings liquidSettings) {
                return Optional.of(new Structure.GenerationStub(this.getStartPos(startPiece, startX, startY, startZ), pieceBuilder -> {
                    ObjectArrayList pieces = new ObjectArrayList();
                    pieces.add(startPiece);
                    if (maxPieces > 0) {
                        this.addPieces(genContext.randomState(), maxPieces, genContext.chunkGenerator(), genContext.structureTemplateManager(), genContext.heightAccessor(), (RandomSource)genContext.random(), (Registry<StructureTemplatePool>)genContext.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL), startPiece, (List<PoolElementStructurePiece>)pieces, Shapes.join((VoxelShape)Shapes.create((AABB)new AABB((double)(startX - maxRadius), -4000.0, (double)(startZ - maxRadius), (double)(startX + maxRadius + 1), 4000.0, (double)(startZ + maxRadius + 1))), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)startPieceBounds)), (BooleanOp)BooleanOp.ONLY_FIRST), liquidSettings);
                        pieces.forEach(arg_0 -> ((StructurePiecesBuilder)pieceBuilder).addPiece(arg_0));
                    }
                    pieceBuilder.offsetPiecesVertically(TopAlignedStructure.this.nextGenHeight - startPieceBounds.maxY());
                }));
            }
        };
    }
}

