/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.tslat.aoa3.common.registration.worldgen.AoAStructureTypes;
import net.tslat.aoa3.content.world.gen.structure.AoAJigsawAssembler;

public class AoAStructure
extends Structure {
    public static final MapCodec<AoAStructure> DEFAULT_CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group(Settings.aoaSettings()).apply((Applicative)codec, AoAStructure::new));
    protected final Settings settings;
    protected final AoAJigsawAssembler assembler;

    public AoAStructure(Settings settings) {
        super(settings.toVanillaSettings());
        this.settings = settings;
        this.assembler = this.getJigsawAssembler();
    }

    protected AoAJigsawAssembler getJigsawAssembler() {
        return new AoAJigsawAssembler();
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext genContext) {
        ChunkPos chunkpos = genContext.chunkPos();
        int startHeight = this.settings.startHeight.sample((RandomSource)genContext.random(), new WorldGenerationContext(genContext.chunkGenerator(), genContext.heightAccessor()));
        BlockPos blockpos = new BlockPos(chunkpos.getMinBlockX(), startHeight, chunkpos.getMinBlockZ());
        return this.assembler.addPieces(genContext, this.settings.startPool, this.settings.startJigsawName, this.settings.maxPieces, blockpos, this.settings.startHeightmap, 128, this.settings.liquidSettings);
    }

    public StructureType<? extends AoAStructure> type() {
        return (StructureType)AoAStructureTypes.AOA_DEFAULT.get();
    }

    public record Settings(HolderSet<Biome> biomes, Map<MobCategory, StructureSpawnOverride> spawnOverrides, GenerationStep.Decoration step, TerrainAdjustment terrainAdaptation, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxPieces, HeightProvider startHeight, Optional<Heightmap.Types> startHeightmap, LiquidSettings liquidSettings) {
        private static final MapCodec<Settings> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(Settings::biomes), (App)Codec.simpleMap((Codec)MobCategory.CODEC, (Codec)StructureSpawnOverride.CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])MobCategory.values())).fieldOf("spawn_overrides").forGetter(Settings::spawnOverrides), (App)GenerationStep.Decoration.CODEC.optionalFieldOf("step", (Object)GenerationStep.Decoration.SURFACE_STRUCTURES).forGetter(Settings::step), (App)TerrainAdjustment.CODEC.optionalFieldOf("terrain_adaptation", (Object)TerrainAdjustment.NONE).forGetter(Settings::terrainAdaptation), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(Settings::startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(Settings::startJigsawName), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("size", (Object)15).forGetter(Settings::maxPieces), (App)HeightProvider.CODEC.optionalFieldOf("start_height", (Object)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0))).forGetter(Settings::startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("heightmap_for_start").forGetter(Settings::startHeightmap), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)LiquidSettings.APPLY_WATERLOGGING).forGetter(Settings::liquidSettings)).apply((Applicative)codec, Settings::new));

        private Structure.StructureSettings toVanillaSettings() {
            return new Structure.StructureSettings(this.biomes, this.spawnOverrides, this.step, this.terrainAdaptation);
        }

        public static <T extends AoAStructure> RecordCodecBuilder<T, Settings> aoaSettings() {
            return CODEC.forGetter(instance -> instance.settings);
        }
    }
}

