/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.tree.trunkplacer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.tslat.aoa3.common.registration.worldgen.AoATrees;
import net.tslat.aoa3.content.world.gen.feature.tree.trunkplacer.AoATrunkPlacer;

public class AoAGiantTrunkPlacer
extends AoATrunkPlacer {
    public static final MapCodec<AoAGiantTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(builder -> AoAGiantTrunkPlacer.heightValues(builder).apply((Applicative)builder, AoAGiantTrunkPlacer::new));

    public AoAGiantTrunkPlacer(IntProvider baseHeight, IntProvider additionalHeight) {
        super(baseHeight, additionalHeight);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)AoATrees.AOA_GIANT_TRUNK.get();
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos startPos, TreeConfiguration config) {
        BlockPos blockpos = startPos.below();
        BlockPos.MutableBlockPos placementPos = new BlockPos.MutableBlockPos();
        AoAGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockpos, (TreeConfiguration)config);
        AoAGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockpos.east(), (TreeConfiguration)config);
        AoAGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockpos.south(), (TreeConfiguration)config);
        AoAGiantTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockpos.south().east(), (TreeConfiguration)config);
        for (int yOffset = 0; yOffset < freeTreeHeight; ++yOffset) {
            this.placeLogIfFreeWithOffset(level, blockSetter, random, placementPos, config, startPos, 0, yOffset, 0);
            if (yOffset >= freeTreeHeight - 1) continue;
            this.placeLogIfFreeWithOffset(level, blockSetter, random, placementPos, config, startPos, 1, yOffset, 0);
            this.placeLogIfFreeWithOffset(level, blockSetter, random, placementPos, config, startPos, 1, yOffset, 1);
            this.placeLogIfFreeWithOffset(level, blockSetter, random, placementPos, config, startPos, 0, yOffset, 1);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(startPos.above(freeTreeHeight), 0, true));
    }

    private void placeLogIfFreeWithOffset(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos.MutableBlockPos pos, TreeConfiguration config, BlockPos offsetPos, int offsetX, int offsetY, int offsetZ) {
        this.placeLogIfFree(level, blockSetter, random, pos.setWithOffset((Vec3i)offsetPos, offsetX, offsetY, offsetZ), config);
    }
}

