/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.tree.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.tslat.aoa3.common.registration.worldgen.AoATrees;

public class OpteryxNestTreeDecorator
extends TreeDecorator {
    public static final MapCodec<OpteryxNestTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(instance -> Float.valueOf(instance.probability)), (App)ConfiguredFeature.CODEC.fieldOf("nest_feature").forGetter(instance -> instance.nestFeature)).apply((Applicative)builder, OpteryxNestTreeDecorator::new));
    private final float probability;
    private final Holder<ConfiguredFeature<?, ?>> nestFeature;

    public OpteryxNestTreeDecorator(float probability, Holder<ConfiguredFeature<?, ?>> nestFeature) {
        this.probability = probability;
        this.nestFeature = nestFeature;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AoATrees.OPTERYX_NEST_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        if (context.logs().isEmpty()) {
            return;
        }
        RandomSource random = context.random();
        if (random.nextFloat() >= this.probability) {
            return;
        }
        ServerChunkCache chunkSource = null;
        ServerLevel genLevel = null;
        LevelSimulatedReader levelSimulatedReader = context.level();
        Objects.requireNonNull(levelSimulatedReader);
        LevelSimulatedReader levelSimulatedReader2 = levelSimulatedReader;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WorldGenRegion.class, ServerLevel.class}, (Object)levelSimulatedReader2, n)) {
            case 0: {
                WorldGenRegion region = (WorldGenRegion)levelSimulatedReader2;
                chunkSource = region.getLevel().getChunkSource();
                genLevel = region;
                break;
            }
            case 1: {
                ServerLevel level = (ServerLevel)levelSimulatedReader2;
                chunkSource = level.getChunkSource();
                genLevel = level;
                break;
            }
        }
        if (chunkSource == null) {
            return;
        }
        ServerLevel level = genLevel;
        ConfiguredFeature nest = (ConfiguredFeature)this.nestFeature.value();
        BlockPos trunkBase = (BlockPos)context.logs().getFirst();
        ObjectArrayList coreTrunkColumn = new ObjectArrayList();
        BlockPos trunkTop = context.logs().stream().filter(pos -> pos.getX() == trunkBase.getX() && pos.getZ() == trunkBase.getZ()).peek(((List)coreTrunkColumn)::add).max(Comparator.comparingInt(Vec3i::getY)).get();
        if (coreTrunkColumn.size() <= 16) {
            return;
        }
        int nestAnchorIndex = random.nextInt(Mth.floor((float)((float)coreTrunkColumn.size() * 0.6f)), coreTrunkColumn.size() - 6);
        BlockPos nestAnchorPos = (BlockPos)coreTrunkColumn.get(nestAnchorIndex);
        Object2ObjectOpenHashMap trunkSectionSnapshot = new Object2ObjectOpenHashMap();
        context.logs().stream().filter(pos -> pos.getY() >= nestAnchorPos.getY() && pos.getY() <= Math.min(nestAnchorPos.getY() + 10, trunkTop.getY())).filter(pos -> pos.getX() == nestAnchorPos.getX() + 1 || pos.getZ() == nestAnchorPos.getZ() - 1 || pos.getX() == nestAnchorPos.getX() + 1 && pos.getZ() == nestAnchorPos.getZ() - 1).forEach(arg_0 -> OpteryxNestTreeDecorator.lambda$place$6((Map)trunkSectionSnapshot, (WorldGenLevel)level, arg_0));
        nest.feature().place(nest.config(), (WorldGenLevel)level, chunkSource.getGenerator(), context.random(), nestAnchorPos.offset(-4, 0, -3));
        for (Map.Entry trunkBlock : trunkSectionSnapshot.entrySet()) {
            if (level.getBlockState((BlockPos)trunkBlock.getKey()) == trunkBlock.getValue()) continue;
            level.setBlock((BlockPos)trunkBlock.getKey(), (BlockState)trunkBlock.getValue(), 2);
        }
    }

    private static /* synthetic */ void lambda$place$6(Map trunkSectionSnapshot, WorldGenLevel level, BlockPos pos) {
        trunkSectionSnapshot.put(pos, level.getBlockState(pos));
    }
}

