/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class FluidChuteFeature
extends Feature<Configuration> {
    public FluidChuteFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        BlockPos startPos = context.origin();
        Configuration config = (Configuration)context.config();
        RandomSource rand = context.random();
        int depth = config.maxDepth().sample(rand);
        int fluidRadius = config.fluidDiameter().sample(rand) / 2;
        int chuteRadius = config.chuteDiameter().sample(rand) / 2;
        BlockPos.MutableBlockPos pos = startPos.mutable();
        WorldGenLevel level = context.level();
        int fluidHypot = fluidRadius * fluidRadius;
        int chuteHypot = chuteRadius * chuteRadius;
        int chuteDepth = Math.min(depth, pos.getY() - level.getMinBuildHeight());
        for (int i = 0; i < chuteDepth; ++i) {
            for (int x = -fluidRadius; x <= fluidRadius; ++x) {
                for (int z = -fluidRadius; z <= fluidRadius; ++z) {
                    BlockState state;
                    int radius = x * x + z * z;
                    if (!((double)radius < (double)fluidHypot + rand.nextGaussian() * 4.0 + 1.0) || !(state = level.getBlockState((BlockPos)pos.setWithOffset((Vec3i)startPos, x, -i, z))).isAir() && (!((double)radius < (double)chuteHypot + rand.nextGaussian() * 4.0 + 1.0) || !(state.getDestroySpeed((BlockGetter)level, (BlockPos)pos) >= 0.0f))) continue;
                    BlockState aboveState = level.getBlockState(pos.above());
                    if (aboveState.isAir()) {
                        while (pos.getY() - 1 > level.getMinBuildHeight() && level.getBlockState(pos.below()).isAir()) {
                            pos.move(0, -1, 0);
                        }
                    }
                    BlockState fluid = config.fluid().getState(rand, (BlockPos)pos);
                    level.setBlock((BlockPos)pos, fluid, 2);
                    if (aboveState.isAir()) {
                        this.markAboveForPostProcessing(level, pos.immutable());
                    }
                    if (pos.getY() < startPos.getY()) continue;
                    level.scheduleTick(pos.immutable(), fluid.getFluidState().getType(), 0);
                }
            }
        }
        return true;
    }

    public record Configuration(BlockStateProvider fluid, IntProvider fluidDiameter, IntProvider chuteDiameter, IntProvider maxDepth) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("fluid").forGetter(Configuration::fluid), (App)IntProvider.CODEC.fieldOf("fluid_diameter").forGetter(Configuration::fluidDiameter), (App)IntProvider.CODEC.fieldOf("chute_diameter").forGetter(Configuration::chuteDiameter), (App)IntProvider.CODEC.fieldOf("max_depth").forGetter(Configuration::maxDepth)).apply((Applicative)instance, Configuration::new));
    }
}

