/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class BlockTowerFeature
extends Feature<Configuration> {
    public BlockTowerFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos basePos = context.origin();
        Configuration config = (Configuration)context.config();
        int baseRadius = config.baseRadius.sample(random);
        int tipRadius = config.tipRadius.sample(random);
        int height = config.height.sample(random);
        float pitting = config.pitting.sample(random);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < height; ++i) {
            BlockPos columnPos = basePos.offset(0, i, 0);
            float width = Mth.lerp((float)((float)i / (float)height), (float)baseRadius, (float)tipRadius);
            float xRadius = random.nextFloat() * width;
            float yRadius = random.nextFloat() * width;
            float zRadius = random.nextFloat() * width;
            float radius = (xRadius + yRadius + zRadius) / 3.0f + 0.5f;
            xRadius = Mth.floor((float)xRadius);
            yRadius = Mth.floor((float)yRadius);
            zRadius = Mth.floor((float)zRadius);
            int x = -((int)xRadius);
            while ((float)x <= xRadius) {
                int y = -((int)yRadius);
                while ((float)y <= yRadius) {
                    int z = -((int)zRadius);
                    while ((float)z <= zRadius) {
                        double dist = columnPos.distSqr((Vec3i)pos.setWithOffset((Vec3i)columnPos, x, y, z));
                        if (dist <= (double)(radius * radius)) {
                            boolean canDoPitting;
                            boolean bl = canDoPitting = pitting > 0.0f && radius > 2.0f && ((float)Mth.abs((int)x) == Mth.abs((float)xRadius) || (float)Mth.abs((int)z) == Mth.abs((float)zRadius));
                            if (!canDoPitting || random.nextFloat() > pitting) {
                                level.setBlock((BlockPos)pos, config.blockState.getState(random, (BlockPos)pos), 3);
                            }
                            if (i == 0) {
                                while (level.getBlockState((BlockPos)pos.move(Direction.DOWN)).isAir() && pos.getY() > level.getMinBuildHeight()) {
                                    if (canDoPitting && !(random.nextFloat() > pitting)) continue;
                                    level.setBlock((BlockPos)pos, config.blockState.getState(random, (BlockPos)pos), 3);
                                }
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return true;
    }

    public record Configuration(IntProvider baseRadius, IntProvider tipRadius, IntProvider height, FloatProvider pitting, BlockStateProvider blockState) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IntProvider.POSITIVE_CODEC.fieldOf("base_radius").forGetter(Configuration::baseRadius), (App)IntProvider.POSITIVE_CODEC.fieldOf("tip_radius").forGetter(Configuration::tipRadius), (App)IntProvider.POSITIVE_CODEC.fieldOf("height").forGetter(Configuration::height), (App)FloatProvider.codec((float)0.0f, (float)1.0f).fieldOf("pitting").forGetter(Configuration::pitting), (App)BlockStateProvider.CODEC.fieldOf("block").forGetter(Configuration::blockState)).apply((Applicative)builder, Configuration::new));
    }
}

