/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class BetterBlockBlobFeature
extends Feature<Configuration> {
    public BetterBlockBlobFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        BlockPos.MutableBlockPos pos = context.origin().mutable().move(Direction.UP);
        while (pos.move(Direction.DOWN).getY() > level.getMinBuildHeight() + 3 && !config.shouldPlace(level, (BlockPos)pos, random)) {
        }
        if (pos.getY() <= level.getMinBuildHeight() + 3) {
            return false;
        }
        int size = config.getSize(random);
        int halfSize = size / 2;
        int blockCount = config.getBlockCount(random);
        for (int i = 0; i < blockCount; ++i) {
            int x = random.nextInt(size);
            int y = random.nextInt(size);
            int z = random.nextInt(size);
            float radius = (float)(x + y + z) / 3.0f + 0.5f;
            for (BlockPos offsetPos : BlockPos.betweenClosed((BlockPos)pos.offset(-x, -y, -z), (BlockPos)pos.offset(x, y, z))) {
                if (!(offsetPos.distSqr((Vec3i)pos) <= (double)(radius * radius))) continue;
                level.setBlock(offsetPos, config.states.getState(random, offsetPos), 3);
            }
            pos.move(-halfSize + random.nextInt(size), -random.nextInt(size), -halfSize + random.nextInt(size));
        }
        return true;
    }

    public record Configuration(BlockStateProvider states, List<RuleTest> placingIn, IntProvider blocks, IntProvider size) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockStateProvider.CODEC.fieldOf("states").forGetter(Configuration::states), (App)RuleTest.CODEC.listOf().fieldOf("placing_in").forGetter(Configuration::targetBlockPredicate), (App)IntProvider.CODEC.optionalFieldOf("blocks", (Object)ConstantInt.of((int)3)).forGetter(Configuration::blocks), (App)IntProvider.CODEC.optionalFieldOf("size", (Object)ConstantInt.of((int)2)).forGetter(Configuration::size)).apply((Applicative)builder, Configuration::new));

        public List<RuleTest> targetBlockPredicate() {
            return this.placingIn;
        }

        public BlockState sample(RandomSource random, BlockPos pos) {
            return this.states.getState(random, pos);
        }

        public boolean shouldPlace(WorldGenLevel level, BlockPos pos, RandomSource random) {
            BlockState state = level.getBlockState(pos);
            for (RuleTest rule : this.placingIn) {
                if (!rule.test(state, random)) continue;
                return true;
            }
            return false;
        }

        public int getBlockCount(RandomSource random) {
            return this.blocks.sample(random);
        }

        public int getSize(RandomSource random) {
            return this.size.sample(random);
        }
    }
}

