/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.event;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.custom.AoAWorldEvents;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.content.world.event.AoAWorldEvent;
import net.tslat.aoa3.util.DamageUtil;

public class BarathosSandstormEvent
implements AoAWorldEvent {
    public static final MapCodec<BarathosSandstormEvent> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)AoAWorldEvent.GenericSettings.CODEC.fieldOf("base_settings").forGetter(event -> event.baseSettings), (App)IntProvider.POSITIVE_CODEC.fieldOf("interval").forGetter(event -> event.interval), (App)IntProvider.POSITIVE_CODEC.fieldOf("duration").forGetter(event -> event.duration), (App)FloatProvider.CODEC.fieldOf("damage").forGetter(event -> event.damage)).apply((Applicative)builder, BarathosSandstormEvent::new));
    private final AoAWorldEvent.GenericSettings baseSettings;
    private final IntProvider interval;
    private final IntProvider duration;
    private final FloatProvider damage;
    private boolean active = false;
    private long nextSandstorm = -1L;
    private long sandstormEndTime = -1L;
    private long sandstormStartTime = -1L;

    public BarathosSandstormEvent() {
        this(null, null, null, null);
    }

    public BarathosSandstormEvent(AoAWorldEvent.GenericSettings baseSettings, IntProvider interval, IntProvider duration, FloatProvider damage) {
        this.baseSettings = baseSettings;
        this.interval = interval;
        this.duration = duration;
        this.damage = damage;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean shouldAddToDimension(ServerLevel level) {
        return this.baseSettings.dimensions().contains(level.dimension());
    }

    @Override
    public AoAWorldEvent copy() {
        return new BarathosSandstormEvent(this.baseSettings, this.interval, this.duration, this.damage);
    }

    @Override
    public ResourceLocation getId() {
        return this.baseSettings.id();
    }

    public AoAWorldEvent.Type<BarathosSandstormEvent> getType() {
        return (AoAWorldEvent.Type)AoAWorldEvents.BARATHOS_SANDSTORM.get();
    }

    @Override
    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("Active", this.active);
        tag.putLong("NextSandstorm", this.nextSandstorm);
        tag.putLong("SandstormEndTime", this.sandstormEndTime);
        tag.putLong("SandstormStartTime", this.sandstormStartTime);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.active = tag.getBoolean("Active");
        this.nextSandstorm = tag.getLong("NextSandstorm");
        this.sandstormEndTime = tag.getLong("SandstormEndTime");
        this.sandstormStartTime = tag.getLong("SandstormStartTime");
    }

    @Override
    public void tick(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!this.isActive()) {
            if (this.nextSandstorm == -1L) {
                this.nextSandstorm = serverLevel.getGameTime() + (long)this.interval.sample(serverLevel.getRandom());
            }
            if (this.nextSandstorm <= serverLevel.getGameTime()) {
                this.start(serverLevel);
            }
            return;
        }
        if (this.sandstormEndTime >= 0L && this.sandstormEndTime <= serverLevel.getGameTime()) {
            this.stop(serverLevel);
            return;
        }
        if (this.getIntensity(serverLevel.getGameTime()) >= 1.0f && serverLevel.getGameTime() % 10L == 0L) {
            DamageSource source = DamageUtil.miscDamage(AoADamageTypes.SANDSTORM, (Level)serverLevel);
            Streams.stream((Iterable)serverLevel.getEntities().getAll()).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(this::isEntityAffected).forEach(entity -> entity.hurt(source, this.damage.sample(serverLevel.getRandom())));
        }
    }

    public float getIntensity(long gameTime) {
        return Math.min(1.0f, Math.min((float)(gameTime - this.sandstormStartTime) / 600.0f, (float)(this.sandstormEndTime - gameTime) / 100.0f));
    }

    public boolean isEntityAffected(LivingEntity entity) {
        return entity.getY() >= 90.0 && entity.level().getBrightness(LightLayer.SKY, entity.blockPosition()) == 15 && !entity.getType().is(AoATags.Entities.IMMUNE_TO_SANDSTORM) && (!(entity instanceof Player) || entity.tickCount > 60);
    }

    @Override
    public void start(ServerLevel level) {
        this.active = true;
        this.sandstormStartTime = level.getGameTime();
        this.sandstormEndTime = this.sandstormStartTime + (long)this.duration.sample(level.getRandom());
        this.markDirty(level);
    }

    @Override
    public void stop(ServerLevel level) {
        this.active = false;
        this.nextSandstorm = level.getGameTime() + (long)this.interval.sample(level.getRandom());
        this.sandstormEndTime = -1L;
        this.sandstormStartTime = -1L;
        this.markDirty(level);
    }
}

