/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.skill.hauling;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.skill.hauling.HaulingEntity;
import net.tslat.aoa3.library.object.RandomEntryPool;
import org.jetbrains.annotations.Nullable;

public class HaulingSpawnPool
extends RandomEntryPool<HaulingEntity, ServerPlayer> {
    public static final Codec<HaulingSpawnPool> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(HaulingSpawnPool::getBiomes), (App)NeoForgeRegistries.FLUID_TYPES.byNameCodec().fieldOf("for_fluid").forGetter(HaulingSpawnPool::getFluidType), (App)Codec.BOOL.optionalFieldOf("is_default", (Object)false).forGetter(HaulingSpawnPool::isDefaultForFluid), (App)Codec.BOOL.optionalFieldOf("is_trap", (Object)false).forGetter(HaulingSpawnPool::isTrap), (App)HaulingEntity.CODEC.xmap(HaulingEntity::toPoolEntry, RandomEntryPool.PoolEntry::get).listOf().fieldOf("entries").forGetter(pool -> pool.entries)).apply((Applicative)instance, HaulingSpawnPool::new));
    private static final Map<FluidType, Map<Holder<Biome>, HaulingSpawnPool>> POOL_LOOKUP = new Object2ObjectOpenHashMap();
    private static final Map<FluidType, Map<Holder<Biome>, HaulingSpawnPool>> TRAP_POOL_LOOKUP = new Object2ObjectOpenHashMap();
    private final HolderSet<Biome> biomes;
    private final FluidType fluidType;
    private final boolean isDefaultForFluid;
    private final boolean isTrap;

    HaulingSpawnPool(HolderSet<Biome> forBiomes, FluidType fluidType, boolean isDefaultForFluid, boolean isTrap, List<RandomEntryPool.PoolEntry<HaulingEntity, ServerPlayer>> entries) {
        super(entries, RandomSource.create());
        this.biomes = forBiomes;
        this.fluidType = fluidType;
        this.isDefaultForFluid = isDefaultForFluid;
        this.isTrap = isTrap;
    }

    public HolderSet<Biome> getBiomes() {
        return this.biomes;
    }

    public FluidType getFluidType() {
        return this.fluidType;
    }

    public boolean isDefaultForFluid() {
        return this.isDefaultForFluid;
    }

    public boolean isTrap() {
        return this.isTrap;
    }

    public static Optional<HaulingSpawnPool> getPoolForLocation(Level level, BlockPos pos, FluidType forFluid) {
        return HaulingSpawnPool.getPoolForBiome(level, (Holder<Biome>)level.getBiome(pos), forFluid);
    }

    public static Optional<HaulingSpawnPool> getPoolForBiome(Level level, Holder<Biome> biome, FluidType forFluid) {
        Map<Holder<Biome>, HaulingSpawnPool> pool2;
        if (POOL_LOOKUP.isEmpty()) {
            ((Registry)level.registryAccess().registry(AoARegistries.HAULING_SPAWN_POOLS_REGISTRY_KEY).orElseThrow()).stream().filter(pool -> !pool.isTrap()).forEach(pool -> {
                Map pools = POOL_LOOKUP.computeIfAbsent(pool.getFluidType(), key -> new Object2ObjectOpenHashMap());
                if (pool.isDefaultForFluid()) {
                    pools.put(null, pool);
                } else {
                    pool.getBiomes().forEach(poolBiome -> pools.put(poolBiome, pool));
                }
            });
        }
        if ((pool2 = POOL_LOOKUP.get(forFluid)) == null) {
            return Optional.empty();
        }
        if (pool2.containsKey(biome)) {
            return Optional.of(pool2.get(biome));
        }
        return Optional.ofNullable(pool2.get(null));
    }

    public static Optional<HaulingSpawnPool> getTrapsPoolForLocation(Level level, BlockPos pos, FluidType forFluid) {
        return HaulingSpawnPool.getPoolForBiome(level, (Holder<Biome>)level.getBiome(pos), forFluid);
    }

    public static Optional<HaulingSpawnPool> getTrapsPoolForBiome(Level level, Holder<Biome> biome, FluidType forFluid) {
        Map<Holder<Biome>, HaulingSpawnPool> pool2;
        if (TRAP_POOL_LOOKUP.isEmpty()) {
            ((Registry)level.registryAccess().registry(AoARegistries.HAULING_SPAWN_POOLS_REGISTRY_KEY).orElseThrow()).stream().filter(HaulingSpawnPool::isTrap).forEach(pool -> {
                Map pools = TRAP_POOL_LOOKUP.computeIfAbsent(pool.getFluidType(), key -> new Object2ObjectOpenHashMap());
                if (pool.isDefaultForFluid()) {
                    pools.put(null, pool);
                } else {
                    pool.getBiomes().forEach(poolBiome -> pools.put(poolBiome, pool));
                }
            });
        }
        if ((pool2 = TRAP_POOL_LOOKUP.get(forFluid)) == null) {
            return Optional.empty();
        }
        if (pool2.containsKey(biome)) {
            return Optional.of(pool2.get(biome));
        }
        return Optional.ofNullable(pool2.get(null));
    }

    static {
        NeoForge.EVENT_BUS.addListener(ServerStoppedEvent.class, ev -> {
            POOL_LOOKUP.clear();
            TRAP_POOL_LOOKUP.clear();
        });
    }

    public static class Builder {
        private final FluidType fluidType;
        private final List<RandomEntryPool.PoolEntry<HaulingEntity, ServerPlayer>> entries = new ObjectArrayList();
        private final HolderSet<Biome> forBiomes;
        private boolean isTrap = false;

        Builder(Holder<FluidType> fluidType, HolderSet<Biome> forBiomes) {
            this.fluidType = (FluidType)fluidType.value();
            this.forBiomes = forBiomes;
        }

        public static Builder forFluid(Holder<FluidType> fluidType, HolderSet<Biome> forBiomes) {
            return new Builder(fluidType, forBiomes);
        }

        public static Builder forFluidAsDefaultPool(Holder<FluidType> fluidType) {
            return Builder.forFluid(fluidType, (HolderSet<Biome>)HolderSet.empty());
        }

        public Builder isTrapPool() {
            this.isTrap = true;
            return this;
        }

        public Builder entity(EntityType<?> entity) {
            return this.entity(entity, 1, 1);
        }

        public Builder entity(EntityType<?> entity, int weight) {
            return this.entity(entity, null, weight, 0.0f, 1);
        }

        public Builder entity(EntityType<?> entity, int weight, float weightMod) {
            return this.entity(entity, null, weight, weightMod, 1);
        }

        public Builder entity(EntityType<?> entity, int weight, int level) {
            return this.entity(entity, null, weight, 0.0f, level);
        }

        public Builder entity(EntityType<?> entity, int weight, float weightMod, int level) {
            return this.entity(entity, null, weight, weightMod, level);
        }

        public Builder entity(EntityType<?> entity, CompoundTag spawnData) {
            return this.entity(entity, spawnData, 1, 1);
        }

        public Builder entity(EntityType<?> entity, CompoundTag spawnData, int weight) {
            return this.entity(entity, spawnData, weight, 0.0f, 1);
        }

        public Builder entity(EntityType<?> entity, CompoundTag spawnData, int weight, float weightMod) {
            return this.entity(entity, spawnData, weight, weightMod, 1);
        }

        public Builder entity(EntityType<?> entity, CompoundTag spawnData, int weight, int level) {
            return this.entity(entity, spawnData, weight, 0.0f, level);
        }

        public Builder entity(EntityType<?> entity, @Nullable CompoundTag spawnData, int weight, float weightMod, int level) {
            this.entries.add(new HaulingEntity(Either.right(entity), Optional.ofNullable(spawnData), weight, level, weightMod).toPoolEntry());
            return this;
        }

        public Builder item(ItemLike item) {
            return this.item(item, 1, 1);
        }

        public Builder item(ItemLike entity, int weight) {
            return this.item(entity, weight, 1);
        }

        public Builder item(ItemLike entity, int weight, float weightMod) {
            return this.item(entity, weight, weightMod, 1);
        }

        public Builder item(ItemLike item, int weight, int level) {
            return this.item(item, weight, 0.0f, level);
        }

        public Builder item(ItemLike item, int weight, float weightMod, int level) {
            return this.item(item.asItem().getDefaultInstance(), weight, weightMod, level);
        }

        public Builder item(ItemStack item) {
            return this.item(item, 1, 1);
        }

        public Builder item(ItemStack entity, int weight) {
            return this.item(entity, weight, 1);
        }

        public Builder item(ItemStack entity, int weight, float weightMod) {
            return this.item(entity, weight, weightMod, 1);
        }

        public Builder item(ItemStack item, int weight, int level) {
            return this.item(item, weight, 0.0f, level);
        }

        public Builder item(ItemStack item, int weight, float weightMod, int level) {
            this.entries.add(new HaulingEntity(Either.left((Object)item), Optional.empty(), weight, level, weightMod).toPoolEntry());
            return this;
        }

        public HaulingSpawnPool build() {
            return new HaulingSpawnPool(this.forBiomes, this.fluidType, this.forBiomes == HolderSet.empty(), this.isTrap, this.entries);
        }
    }
}

