/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.menu.generic.GenericRecipeInput;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.RecipeUtil;
import org.jetbrains.annotations.Nullable;

public record UpgradeKitRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails, Ingredient input, Ingredient upgradeKit, ItemStack output) implements RecipeBookRecipe<GenericRecipeInput>
{
    public UpgradeKitRecipe(String group, @Nullable CraftingBookCategory category, boolean showObtainNotification, Ingredient input, Ingredient upgradeKit, ItemStack output) {
        this(new RecipeUtil.RecipeBookDetails(group, category, showObtainNotification), input, upgradeKit, output);
    }

    public RecipeSerializer<UpgradeKitRecipe> getSerializer() {
        return (RecipeSerializer)AoARecipes.UPGRADE_KIT.serializer().get();
    }

    public RecipeType<UpgradeKitRecipe> getType() {
        return (RecipeType)AoARecipes.UPGRADE_KIT.type().get();
    }

    public ItemStack getToastSymbol() {
        return AoABlocks.DIVINE_STATION.toStack();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of(null, (Object[])new Ingredient[]{this.input, this.upgradeKit});
    }

    public boolean matches(GenericRecipeInput inv, Level world) {
        return this.input.test(inv.getItem(0)) && this.upgradeKit.test(inv.getItem(1));
    }

    public ItemStack assemble(GenericRecipeInput inv, HolderLookup.Provider holderLookup) {
        return this.getResultItem(holderLookup);
    }

    public ItemStack getResultItem(HolderLookup.Provider holderLookup) {
        return this.output.copy();
    }

    public static class Factory
    implements RecipeSerializer<UpgradeKitRecipe> {
        public static final MapCodec<UpgradeKitRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> RecipeUtil.RecipeBookDetails.codec(builder, UpgradeKitRecipe::recipeBookDetails).and(builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(UpgradeKitRecipe::input), (App)Ingredient.CODEC_NONEMPTY.fieldOf("upgrade_kit").forGetter(UpgradeKitRecipe::upgradeKit), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(UpgradeKitRecipe::output))).apply((Applicative)builder, UpgradeKitRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeKitRecipe> STREAM_CODEC = StreamCodec.composite(RecipeUtil.RecipeBookDetails.STREAM_CODEC, UpgradeKitRecipe::recipeBookDetails, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, UpgradeKitRecipe::input, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, UpgradeKitRecipe::upgradeKit, (StreamCodec)ItemStack.STREAM_CODEC, UpgradeKitRecipe::output, UpgradeKitRecipe::new);

        public MapCodec<UpgradeKitRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UpgradeKitRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

