/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.menu.generic.GenericRecipeInput;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.datacomponent.CompressedItemData;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.RecipeUtil;
import org.jetbrains.annotations.Nullable;

public record InfusedPressDecompressionRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails) implements RecipeBookRecipe<GenericRecipeInput>
{
    public InfusedPressDecompressionRecipe(String group, @Nullable CraftingBookCategory category, boolean showObtainNotification) {
        this(new RecipeUtil.RecipeBookDetails(group, category, showObtainNotification));
    }

    public RecipeType<?> getType() {
        return (RecipeType)AoARecipes.INFUSED_PRESS_DECOMPRESSION.type().get();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AoARecipes.INFUSED_PRESS_DECOMPRESSION.serializer().get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public boolean matches(GenericRecipeInput inv, Level level) {
        if (inv.size() < 10) {
            return false;
        }
        ItemStack stack = inv.getItem(9);
        if (!stack.is(AoAItems.COMPRESSED_ITEM) || !stack.has(AoADataComponents.COMPRESSED_ITEM_DATA)) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (inv.getItem(i).isEmpty()) continue;
            return false;
        }
        CompressedItemData data = (CompressedItemData)stack.get(AoADataComponents.COMPRESSED_ITEM_DATA);
        return !data.compressedStack().isEmpty() && data.compressions() >= 1;
    }

    public ItemStack assemble(GenericRecipeInput inv, HolderLookup.Provider holderLookup) {
        if (inv.size() >= 10) {
            ItemStack newStack;
            for (int i = 0; i < 9; ++i) {
                if (inv.getItem(i).isEmpty()) continue;
                return ItemStack.EMPTY;
            }
            ItemStack stack = inv.getItem(9);
            CompressedItemData data = (CompressedItemData)stack.get(AoADataComponents.COMPRESSED_ITEM_DATA);
            if (data.compressions() == 1) {
                newStack = data.compressedStack().copy();
            } else {
                newStack = stack.copy();
                newStack.set(AoADataComponents.COMPRESSED_ITEM_DATA, (Object)data.decompress());
            }
            return newStack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getResultItem(HolderLookup.Provider holderLookup) {
        return AoAItems.COMPRESSED_ITEM.toStack();
    }

    public static class Factory
    implements RecipeSerializer<InfusedPressDecompressionRecipe> {
        public static final MapCodec<InfusedPressDecompressionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> RecipeUtil.RecipeBookDetails.codec(builder, InfusedPressDecompressionRecipe::recipeBookDetails).apply((Applicative)builder, InfusedPressDecompressionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfusedPressDecompressionRecipe> STREAM_CODEC = StreamCodec.composite(RecipeUtil.RecipeBookDetails.STREAM_CODEC, InfusedPressDecompressionRecipe::recipeBookDetails, InfusedPressDecompressionRecipe::new);

        public MapCodec<InfusedPressDecompressionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfusedPressDecompressionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

