/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.tslat.aoa3.common.menu.ImbuingChamberMenu;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.item.misc.AspectFocusItem;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.CodecUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class ImbuingRecipe
implements Recipe<ImbuingRecipeInput> {
    private final boolean showUnlockNotification;
    private final ObjectIntPair<Holder<Enchantment>> enchant;
    private final NonNullList<Ingredient> ingredients;
    private final int imbuingLevelReq;
    private final Optional<FloatProvider> xpOverride;
    private final boolean isSimpleIngredients;

    public ImbuingRecipe(int imbuingLevelReq, Optional<FloatProvider> xpOverride, Holder<Enchantment> enchant, int enchantLevel, NonNullList<Ingredient> foci, Ingredient powerSource, boolean showUnlockNotification) {
        this.enchant = ObjectIntPair.of(enchant, (int)enchantLevel);
        this.ingredients = NonNullList.withSize((int)(foci.size() + 1), (Object)Ingredient.EMPTY);
        this.showUnlockNotification = showUnlockNotification;
        this.imbuingLevelReq = imbuingLevelReq;
        this.xpOverride = xpOverride;
        this.isSimpleIngredients = powerSource.isSimple();
        this.ingredients.set(0, (Object)powerSource);
        for (int i = 0; i < foci.size(); ++i) {
            this.ingredients.set(i + 1, (Object)((Ingredient)foci.get(i)));
        }
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)AoABlocks.IMBUING_CHAMBER.get());
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.getIngredients().size() + 1;
    }

    public int getImbuingLevelReq() {
        return this.imbuingLevelReq;
    }

    public Optional<FloatProvider> getXpOverrideProvider() {
        return this.xpOverride;
    }

    public float getXp(Player player) {
        return this.getXpOverrideProvider().map(floatProvider -> Float.valueOf(floatProvider.sample(player.getRandom()))).orElseGet(() -> Float.valueOf(PlayerUtil.getXpForFractionOfLevel(PlayerUtil.getLevel(player, (AoASkill)AoASkills.IMBUING.get()), (float)Mth.clamp((int)this.getImbuingLevelReq(), (int)1, (int)99) / 100.0f))).floatValue();
    }

    public ObjectIntPair<Holder<Enchantment>> getEnchant() {
        return this.enchant;
    }

    public boolean showNotification() {
        return this.showUnlockNotification;
    }

    public RecipeSerializer<ImbuingRecipe> getSerializer() {
        return (RecipeSerializer)AoARecipes.IMBUING.serializer().get();
    }

    public RecipeType<ImbuingRecipe> getType() {
        return (RecipeType)AoARecipes.IMBUING.type().get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public Ingredient getPowerSource() {
        return (Ingredient)this.getIngredients().get(0);
    }

    public boolean matches(ImbuingRecipeInput input, Level level) {
        ItemStack targetStack = input.getItem(6);
        if (!(targetStack.isEmpty() || input.inventory.imbuing || this.canEnchantInput(targetStack))) {
            return false;
        }
        NonNullList<Ingredient> ingredients = this.getIngredients();
        return this.isSimpleIngredients ? this.checkSimpleIngredients(input, ingredients.size(), targetStack) : this.checkNonSimpleIngredients(input, (List<Ingredient>)ingredients, targetStack);
    }

    public boolean canEnchantInput(ItemStack inputStack) {
        if (inputStack.is(Items.BOOK)) {
            return false;
        }
        Holder enchant = (Holder)this.getEnchant().left();
        if (!((Enchantment)enchant.value()).canEnchant(inputStack) || inputStack.getEnchantmentLevel(enchant) >= this.getEnchant().rightInt()) {
            return false;
        }
        for (Holder existingEnchant : EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)inputStack).keySet()) {
            if (existingEnchant.is(enchant) || Enchantment.areCompatible((Holder)existingEnchant, (Holder)enchant)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSimpleIngredients(ImbuingRecipeInput input, int ingredientsCount, ItemStack inputStack) {
        StackedContents itemHelper = new StackedContents();
        for (ItemStack ingredient : input.inventory.getItems()) {
            if (ingredient.isEmpty() || ingredient == inputStack) continue;
            if (ingredientsCount-- < 0) {
                return false;
            }
            itemHelper.accountStack(ingredient, 1);
        }
        return ingredientsCount == 0 && itemHelper.canCraft((Recipe)this, null);
    }

    private boolean checkNonSimpleIngredients(ImbuingRecipeInput input, List<Ingredient> ingredients, ItemStack inputStack) {
        int ingredientsCount = ingredients.size();
        ObjectArrayList foundIngredients = new ObjectArrayList(ingredientsCount);
        for (ItemStack ingredient : input.inventory.getItems()) {
            if (ingredient.isEmpty() || ingredient == inputStack) continue;
            if (ingredientsCount-- < 0) {
                return false;
            }
            foundIngredients.add(ingredient);
        }
        return ingredientsCount == 0 && RecipeMatcher.findMatches((List)foundIngredients, ingredients) != null;
    }

    public NonNullList<ItemStack> getRemainingItems(ImbuingRecipeInput input) {
        NonNullList returns = NonNullList.withSize((int)(input.size() - 1), (Object)ItemStack.EMPTY);
        for (int i = 0; i < returns.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.hasCraftingRemainingItem()) {
                stack = CommonHooks.getCraftingRemainingItem((ItemStack)stack);
            } else {
                stack = stack.copy();
                if (i > 0) {
                    if (stack.isDamageableItem()) {
                        stack.setDamageValue(stack.getDamageValue() + 1);
                    }
                    if (stack.getDamageValue() >= stack.getMaxDamage()) {
                        stack = ItemStack.EMPTY;
                    }
                } else {
                    stack = ItemStack.EMPTY;
                }
            }
            returns.set(i, (Object)stack);
        }
        return returns;
    }

    public ItemStack assemble(ImbuingRecipeInput input, HolderLookup.Provider holderLookup) {
        ItemStack target = input.getItem(6).copy();
        if (target.isEmpty()) {
            return target;
        }
        target.enchant((Holder)this.getEnchant().left(), this.getEnchant().rightInt());
        return target;
    }

    public ItemStack getResultItem(HolderLookup.Provider holderLookup) {
        return ItemStack.EMPTY.copy();
    }

    public record ImbuingRecipeInput(ImbuingChamberMenu.ImbuingInventory inventory) implements RecipeInput
    {
        public ItemStack getItem(int index) {
            return this.inventory.getItem(index);
        }

        public int size() {
            return this.inventory.getContainerSize();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ImbuingRecipeInput)) {
                return false;
            }
            ImbuingRecipeInput imbuingRecipeInput = (ImbuingRecipeInput)obj;
            return Objects.equals(this, imbuingRecipeInput);
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    public static class Factory
    implements RecipeSerializer<ImbuingRecipe> {
        public static final MapCodec<ImbuingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.intRange((int)1, (int)1000).optionalFieldOf("imbuing_level", (Object)1).forGetter(ImbuingRecipe::getImbuingLevelReq), (App)FloatProvider.CODEC.optionalFieldOf("imbuing_xp_override").forGetter(ImbuingRecipe::getXpOverrideProvider), (App)Enchantment.CODEC.fieldOf("enchantment").forGetter(instance -> (Holder)instance.getEnchant().left()), (App)Codec.intRange((int)0, (int)255).fieldOf("enchantment_level").forGetter(instance -> instance.getEnchant().rightInt()), (App)AoARegistries.AOA_ASPECT_FOCI.lookupCodec().listOf().fieldOf("aspect_foci").xmap(foci -> foci.stream().map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0})).collect(NonNullList::create, AbstractList::add, AbstractCollection::addAll), ingredients -> ingredients.stream().skip(1L).map(ingredient -> ingredient.getItems()[0]).map(ItemStack::getItem).map(AspectFocusItem.class::cast).map(AspectFocusItem::getFocus).toList()).forGetter(ImbuingRecipe::getIngredients), (App)Ingredient.CODEC_NONEMPTY.fieldOf("power_source").forGetter(ImbuingRecipe::getPowerSource), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(instance -> instance.showUnlockNotification)).apply((Applicative)builder, ImbuingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ImbuingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ImbuingRecipe::getImbuingLevelReq, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)FloatProvider.CODEC)), ImbuingRecipe::getXpOverrideProvider, (StreamCodec)ByteBufCodecs.BOOL, ImbuingRecipe::showNotification, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ENCHANTMENT), recipe -> (Holder)recipe.enchant.left(), (StreamCodec)ByteBufCodecs.VAR_INT, recipe -> recipe.enchant.rightInt(), CodecUtil.streamNonNullList(Ingredient.CONTENTS_STREAM_CODEC, Ingredient.EMPTY), ImbuingRecipe::getIngredients, (imbuingLevelReq, xpOverride, showUnlockNotification, enchant, enchantLevel, foci) -> {
            Ingredient powerSource = (Ingredient)foci.getFirst();
            NonNullList patchedIngredients = NonNullList.withSize((int)(foci.size() - 1), (Object)Ingredient.EMPTY);
            for (int i = 1; i < foci.size(); ++i) {
                patchedIngredients.set(i - 1, (Object)((Ingredient)foci.get(i)));
            }
            return new ImbuingRecipe((int)imbuingLevelReq, (Optional<FloatProvider>)xpOverride, (Holder<Enchantment>)enchant, (int)enchantLevel, (NonNullList<Ingredient>)patchedIngredients, powerSource, (boolean)showUnlockNotification);
        });

        public MapCodec<ImbuingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ImbuingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

