/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.RecipeUtil;
import net.tslat.aoa3.util.WorldUtil;

public class AshfernCookingRecipe
extends CustomRecipe
implements RecipeBookRecipe<CraftingInput> {
    private final RecipeUtil.RecipeBookDetails recipeBookDetails;

    public AshfernCookingRecipe(String group, CraftingBookCategory category, boolean showObtainNotification) {
        this(new RecipeUtil.RecipeBookDetails(group, category, showObtainNotification));
    }

    public AshfernCookingRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails) {
        super(recipeBookDetails.category());
        this.recipeBookDetails = recipeBookDetails;
    }

    @Override
    public RecipeUtil.RecipeBookDetails recipeBookDetails() {
        return this.recipeBookDetails;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AoARecipes.ASHFERN_COOKING.serializer().get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.ingredientCount() != 2) {
            return false;
        }
        boolean hasFern = false;
        boolean hasFood = false;
        for (ItemStack stack : input.items()) {
            if (stack.isEmpty()) continue;
            if (stack.is((Item)AoAItems.ASHFERN.get())) {
                if (hasFern) {
                    return false;
                }
                hasFern = true;
                continue;
            }
            if (hasFood || stack.getFoodProperties(null) == null) {
                return false;
            }
            Optional smeltingRecipe = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), level);
            if (smeltingRecipe.isPresent() && !((SmeltingRecipe)((RecipeHolder)smeltingRecipe.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess()).isEmpty()) {
                hasFood = true;
                continue;
            }
            return false;
        }
        return hasFern && hasFood;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider holderLookup) {
        ServerLevel level = WorldUtil.getServer().getLevel(AoADimensions.OVERWORLD);
        if (level == null) {
            return ItemStack.EMPTY;
        }
        boolean foundFern = false;
        ItemStack output = ItemStack.EMPTY;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is((Item)AoAItems.ASHFERN.get())) {
                foundFern = true;
                if (output.isEmpty()) continue;
                break;
            }
            Optional smeltingRecipe = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)level);
            if (smeltingRecipe.isPresent()) {
                output = ((SmeltingRecipe)((RecipeHolder)smeltingRecipe.get()).value()).getResultItem(holderLookup);
            }
            if (foundFern) break;
        }
        if (!foundFern) {
            return ItemStack.EMPTY;
        }
        output = output.copy();
        return output;
    }

    public static class Factory
    implements RecipeSerializer<AshfernCookingRecipe> {
        public static final MapCodec<AshfernCookingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> RecipeUtil.RecipeBookDetails.codec(builder, AshfernCookingRecipe::recipeBookDetails).apply((Applicative)builder, AshfernCookingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AshfernCookingRecipe> STREAM_CODEC = StreamCodec.composite(RecipeUtil.RecipeBookDetails.STREAM_CODEC, AshfernCookingRecipe::recipeBookDetails, AshfernCookingRecipe::new);

        public MapCodec<AshfernCookingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AshfernCookingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

